/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.internal.FallbackMethod;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import io.smallrye.faulttolerance.internal.KotlinSupport;
import io.smallrye.faulttolerance.internal.SecurityActions;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

public final class FallbackMethodCandidates {
    private final FallbackMethod withoutExceptionParam;
    private final Map<Class<?>, FallbackMethod> withExceptionParam;

    private FallbackMethodCandidates(Method withoutExceptionParam, Set<Method> withExceptionParam) {
        this.withoutExceptionParam = FallbackMethod.withoutExceptionParameter(withoutExceptionParam);
        HashMap map = new HashMap();
        for (Method method : withExceptionParam) {
            int exceptionParameterPosition = method.getParameterCount() - 1;
            if (KotlinSupport.isSuspendingFunction(method)) {
                --exceptionParameterPosition;
            }
            map.put(method.getParameterTypes()[exceptionParameterPosition], FallbackMethod.withExceptionParameter(method, exceptionParameterPosition));
        }
        this.withExceptionParam = map;
    }

    public boolean isEmpty() {
        return this.withoutExceptionParam == null && this.withExceptionParam.isEmpty();
    }

    public FallbackMethod select(Class<? extends Throwable> exceptionType) {
        if (!this.withExceptionParam.isEmpty()) {
            for (Class<? extends Throwable> type = exceptionType; type != null; type = type.getSuperclass()) {
                FallbackMethod candidate = this.withExceptionParam.get(type);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return this.withoutExceptionParam;
    }

    public static FallbackMethodCandidates create(InterceptionPoint point, String fallbackMethodName, boolean allowExceptionParam) {
        try {
            Method guardedMethod = point.method();
            Method withoutExceptionParam = SecurityActions.findFallbackMethod(point.beanClass(), guardedMethod.getDeclaringClass(), fallbackMethodName, guardedMethod.getGenericParameterTypes(), guardedMethod.getGenericReturnType());
            if (withoutExceptionParam != null) {
                SecurityActions.setAccessible(withoutExceptionParam);
            }
            Set<Method> withExceptionParam = Collections.emptySet();
            if (allowExceptionParam) {
                withExceptionParam = SecurityActions.findFallbackMethodsWithExceptionParameter(point.beanClass(), guardedMethod.getDeclaringClass(), fallbackMethodName, guardedMethod.getGenericParameterTypes(), guardedMethod.getGenericReturnType());
                for (Method method : withExceptionParam) {
                    SecurityActions.setAccessible(method);
                }
            }
            return new FallbackMethodCandidates(withoutExceptionParam, withExceptionParam);
        }
        catch (PrivilegedActionException e) {
            throw new FaultToleranceException("Could not obtain fallback method " + fallbackMethodName, (Throwable)e);
        }
    }
}

