/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.Connection;
import java.sql.JDBCType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.filter.Filter;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.metadata.sql.internal.shared.SQLBuilder;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.referencing.CRS;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.SelectionClauseWriter;
import org.apache.sis.storage.sql.feature.Table;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class SelectionClause
extends SQLBuilder {
    static final boolean REPLACE_UNSPECIFIED_CRS = true;
    private final Table table;
    private final List<Map.Entry<Integer, CoordinateReferenceSystem>> parameters;
    private Optional<CoordinateReferenceSystem> columnCRS;
    private JDBCType functionReturnType;
    private boolean isInvalid;

    SelectionClause(Table table) {
        super(table.database);
        this.table = table;
        this.parameters = new ArrayList<Map.Entry<Integer, CoordinateReferenceSystem>>();
    }

    final void clearColumnCRS() {
        this.columnCRS = null;
    }

    final boolean acceptColumnCRS(ValueReference<AbstractFeature, ?> ref) {
        Column c = this.table.getColumn(ref.getXPath());
        if (c != null && c.getGeometryType().isPresent()) {
            Optional<CoordinateReferenceSystem> crs = c.getDefaultCRS();
            if (this.columnCRS == null) {
                this.columnCRS = crs;
            } else if (!CRS.equivalent((CoordinateReferenceSystem)this.columnCRS.orElse(null), (CoordinateReferenceSystem)crs.orElse(null))) {
                this.clearColumnCRS();
                return true;
            }
        }
        return false;
    }

    final boolean appendColumnName(String column) {
        Column c = this.table.getColumn(column);
        if (c != null) {
            this.appendIdentifier(c.name);
            return true;
        }
        this.invalidate();
        return false;
    }

    final void appendLiteral(Object value) {
        if (value instanceof GeographicBoundingBox) {
            this.appendGeometry(null, (Envelope)new GeneralEnvelope((GeographicBoundingBox)value));
        } else if (value instanceof Envelope) {
            this.appendGeometry(null, (Envelope)value);
        } else {
            Geometries.wrap((Object)value).ifPresentOrElse(wrapper -> this.appendGeometry((GeometryWrapper)wrapper, null), () -> this.appendValue(value));
        }
    }

    private void appendGeometry(GeometryWrapper wrapper, Envelope bounds) {
        if (bounds == null) {
            if (wrapper == null) {
                this.invalidate();
                return;
            }
            bounds = wrapper.getEnvelope();
        }
        if (bounds.getDimension() < 2) {
            this.invalidate();
            return;
        }
        double span = (bounds.getSpan(0) + bounds.getSpan(1)) / 2.0;
        if (Double.isNaN(span)) {
            GeneralEnvelope e = new GeneralEnvelope(bounds);
            for (int i = 0; i < 2; ++i) {
                double lower = SelectionClause.clampInfinity(e.getLower(i));
                double upper = SelectionClause.clampInfinity(e.getUpper(i));
                if (Double.isNaN(lower) || Double.isNaN(upper)) {
                    this.invalidate();
                    return;
                }
                e.setRange(i, lower, upper);
            }
            bounds = e;
        }
        Database<?> db = this.table.database;
        if (wrapper == null) {
            wrapper = db.geomLibrary.toGeometry2D(bounds, WraparoundMethod.SPLIT);
        }
        String wkt = wrapper.formatWKT(0.05 * span);
        this.appendSpatialFunction("ST_GeomFromText");
        this.append('(').appendValue(wkt);
        if (db.dialect.supportsSRID() && db.getSpatialSchema().isPresent()) {
            CoordinateReferenceSystem crs = wrapper.getCoordinateReferenceSystem();
            if (this.columnCRS != null && crs == null) {
                crs = this.columnCRS.orElse(null);
            }
            if (crs != null) {
                this.buffer.append(", ");
                this.parameters.add(new AbstractMap.SimpleEntry<Integer, CoordinateReferenceSystem>(this.buffer.length(), crs));
                this.buffer.append('?');
            }
        }
        this.append(')');
    }

    private static double clampInfinity(double value) {
        if (value == Double.NEGATIVE_INFINITY) {
            return -1.7976931348623157E308;
        }
        if (value == Double.POSITIVE_INFINITY) {
            return Double.MAX_VALUE;
        }
        return value;
    }

    final JDBCType functionReturnType() {
        return this.isInvalid ? null : this.functionReturnType;
    }

    public final void declareFunction(JDBCType returnType) {
        this.functionReturnType = returnType;
    }

    final void appendSpatialFunction(String name) {
        Database<?> db = this.table.database;
        this.appendIdentifier(db.catalogOfSpatialTables, db.schemaOfSpatialTables, name, false);
    }

    final boolean tryAppend(SelectionClauseWriter writer, Filter<? super AbstractFeature> filter) {
        int pos = this.buffer.length();
        if (pos != 0) {
            this.buffer.append(" AND ");
        }
        if (writer.write(this, filter)) {
            this.buffer.setLength(pos);
            this.isInvalid = false;
            return false;
        }
        return true;
    }

    final boolean isInvalid() {
        return this.isInvalid;
    }

    final void invalidate() {
        this.isInvalid = true;
    }

    final String query(Connection connection, InfoStatements spatialInformation) throws Exception {
        if (this.isEmpty()) {
            return null;
        }
        boolean close = false;
        int i = this.parameters.size();
        while (--i >= 0) {
            if (spatialInformation == null) {
                spatialInformation = this.table.database.createInfoStatements(connection);
                close = true;
            }
            Map.Entry<Integer, CoordinateReferenceSystem> entry = this.parameters.get(i);
            int index = entry.getKey();
            int srid = spatialInformation.findSRID(entry.getValue());
            this.buffer.replace(index, index + 1, Integer.toString(srid));
        }
        if (close) {
            spatialInformation.close();
        }
        return this.buffer.toString();
    }

    public final SQLBuilder clear() {
        this.isInvalid = false;
        this.functionReturnType = null;
        this.clearColumnCRS();
        this.parameters.clear();
        return super.clear();
    }
}

