/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.system;

import java.io.Console;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.sis.pending.jdk.JDK17;

public final class Environment {
    private static boolean avoidConsoleWriter;

    private Environment() {
    }

    public static void avoidConsoleWriter() {
        avoidConsoleWriter = true;
    }

    public static PrintWriter writer() {
        return Environment.writer(System.console(), System.out);
    }

    public static PrintWriter writer(Console console, PrintStream fallback) {
        if (console == null) {
            return new PrintWriter(fallback, true);
        }
        if (avoidConsoleWriter) {
            return new PrintWriter((Writer)new OutputStreamWriter((OutputStream)fallback, JDK17.charset(console)), true);
        }
        return console.writer();
    }
}

