/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.util.function.DoubleUnaryOperator;
import org.apache.sis.math.ArrayVector;
import org.apache.sis.math.CompoundDirectPositions;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;

public class Line
implements DoubleUnaryOperator,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2185952238314399110L;
    private static final int DIMENSION = 2;
    private double slope;
    private double y0;
    private double x0;

    public Line() {
        this.x0 = Double.NaN;
        this.y0 = Double.NaN;
        this.slope = Double.NaN;
    }

    public Line(double slope, double y0) {
        this.slope = slope;
        this.y0 = y0;
        this.x0 = -y0 / slope;
    }

    public final double slope() {
        return this.slope;
    }

    public final double x0() {
        return this.x0;
    }

    public final double x(double y) {
        return this.x0 + y / this.slope;
    }

    public final double y0() {
        return this.y0;
    }

    public final double y(double x) {
        return this.y0 + x * this.slope;
    }

    @Override
    public double applyAsDouble(double x) {
        return this.y(x);
    }

    public void translate(double dx, double dy) {
        if (this.slope == 0.0 || Double.isInfinite(this.slope)) {
            this.x0 += dx;
            this.y0 += dy;
        } else {
            this.x0 += dx - dy / this.slope;
            this.y0 += dy - this.slope * dx;
        }
    }

    public void setEquation(double slope, double y0) {
        this.slope = slope;
        this.y0 = y0;
        this.x0 = -y0 / slope;
    }

    public void setEquation(Number slope, Number y0) {
        this.setEquation(slope.doubleValue(), y0.doubleValue());
    }

    public void setFromPoints(double x1, double y1, double x2, double y2) {
        this.slope = (y2 - y1) / (x2 - x1);
        this.x0 = x2 - y2 / this.slope;
        this.y0 = y2 - this.slope * x2;
        if (Double.isNaN(this.x0) && this.slope == 0.0) {
            this.x0 = Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(this.y0) && Double.isInfinite(this.slope)) {
            this.y0 = Double.POSITIVE_INFINITY;
        }
    }

    public double fit(double[] x, double[] y) {
        ArgumentChecks.ensureNonNull("x", x);
        ArgumentChecks.ensureNonNull("y", y);
        return this.fit(new ArrayVector.Doubles(x), new ArrayVector.Doubles(y));
    }

    public double fit(Vector x, Vector y) {
        ArgumentChecks.ensureNonNull("x", x);
        ArgumentChecks.ensureNonNull("y", y);
        return this.fit(new CompoundDirectPositions(x, y));
    }

    /*
     * WARNING - void declaration
     */
    public double fit(Iterable<? extends DirectPosition> points) {
        void var7_9;
        double y;
        int i = 0;
        int n = 0;
        DoubleDouble mean_x = DoubleDouble.ZERO;
        DoubleDouble mean_y = DoubleDouble.ZERO;
        for (DirectPosition directPosition : points) {
            double x;
            int dimension = directPosition.getDimension();
            if (dimension != 2) {
                throw new MismatchedDimensionException(Errors.format((short)101, Strings.toIndexed("points", i), 2, dimension));
            }
            ++i;
            y = directPosition.getOrdinate(1);
            if (Double.isNaN(y) || Double.isNaN(x = directPosition.getOrdinate(0))) continue;
            mean_x = mean_x.add(x, false);
            mean_y = mean_y.add(y, false);
            ++n;
        }
        mean_x = mean_x.divide(n);
        mean_y = mean_y.divide(n);
        DoubleDouble mean_x2 = DoubleDouble.ZERO;
        DoubleDouble doubleDouble = DoubleDouble.ZERO;
        DoubleDouble mean_xy = DoubleDouble.ZERO;
        for (DirectPosition directPosition : points) {
            double x;
            y = directPosition.getOrdinate(1);
            if (Double.isNaN(y) || Double.isNaN(x = directPosition.getOrdinate(0))) continue;
            DoubleDouble dx = DoubleDouble.of(x, true).subtract(mean_x);
            mean_x2 = mean_x2.add(dx.square());
            mean_xy = mean_xy.add(dx.multiply(y, true));
            DoubleDouble doubleDouble2 = var7_9.add(DoubleDouble.product(y, y));
        }
        mean_x2 = mean_x2.divide(n);
        DoubleDouble doubleDouble3 = var7_9.divide(n);
        mean_xy = mean_xy.divide(n);
        DoubleDouble a = mean_xy.divide(mean_x2);
        DoubleDouble doubleDouble4 = mean_y.subtract(mean_x.multiply(a));
        this.setEquation(a, doubleDouble4);
        return mean_xy.divide(mean_x2.multiply(doubleDouble3.subtract(mean_y.square())).sqrt()).doubleValue();
    }

    public Line clone() {
        try {
            return (Line)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            Line that = (Line)object;
            return Numerics.equals(this.slope, that.slope) && Numerics.equals(this.y0, that.y0) && Numerics.equals(this.x0, that.x0);
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(0x1E560FFAA4B32586L ^ Double.doubleToLongBits(this.slope) + 31L * Double.doubleToLongBits(this.y0));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(50);
        if (Double.isInfinite(this.slope)) {
            buffer.append("x = ").append(this.x0);
        } else {
            buffer.append("y = ");
            String separator = "";
            if (this.slope != 0.0) {
                buffer.append(this.slope).append("\u22c5x");
                separator = " + ";
            }
            if (this.y0 != 0.0) {
                buffer.append(separator).append(this.y0);
            }
        }
        return buffer.toString();
    }
}

