/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.AbstractRegistry;
import com.netflix.spectator.api.DefaultId;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;

public final class SpectatorUtils {
    private SpectatorUtils() {
    }

    public static Id createDefaultId(String name) {
        return new DefaultId(name);
    }

    public static void removeExpiredMeters(Registry registry) {
        if (registry instanceof AbstractRegistry) {
            ((AbstractRegistry)registry).removeExpiredMeters();
        }
    }

    public static void registerMeter(Registry registry, Meter meter) {
        if (!(registry instanceof AbstractRegistry)) {
            throw new IllegalStateException("registry must be a AbstractRegistry, class=" + registry.getClass().getName());
        }
        ((AbstractRegistry)registry).getOrCreate(meter.id(), Meter.class, null, _id -> meter);
    }
}

