/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.Arrays;
import java.util.List;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTagFormatMapper;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;

public class POSTaggerNameFeatureGenerator
implements AdaptiveFeatureGenerator {
    private final POSTagger posTagger;
    private String[] cachedTokens;
    private String[] cachedTags;

    public POSTaggerNameFeatureGenerator(POSTagger aPosTagger) {
        this.posTagger = aPosTagger;
    }

    public POSTaggerNameFeatureGenerator(POSModel aPosModel) {
        this.posTagger = new POSTaggerME(aPosModel, POSTagFormatMapper.guessFormat(aPosModel));
    }

    public void createFeatures(List<String> feats, String[] toks, int index, String[] preds) {
        if (!Arrays.equals(this.cachedTokens, toks)) {
            this.cachedTokens = toks;
            this.cachedTags = this.posTagger.tag(toks);
        }
        feats.add("pos=" + this.cachedTags[index]);
    }
}

