/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.IOException;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class TokenizerStream
implements ObjectStream<TokenSample> {
    private final Tokenizer tokenizer;
    private final ObjectStream<String> input;

    public TokenizerStream(Tokenizer tokenizer, ObjectStream<String> input) {
        this.tokenizer = tokenizer;
        this.input = input;
    }

    public TokenSample read() throws IOException {
        String inputString = (String)this.input.read();
        if (inputString != null) {
            Span[] tokens = this.tokenizer.tokenizePos(inputString);
            return new TokenSample(inputString, tokens);
        }
        return null;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void reset() throws IOException, UnsupportedOperationException {
        this.input.reset();
    }
}

