/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.util.function.Consumer;
import org.springframework.security.authorization.AllRequiredFactorsAuthorizationManager;
import org.springframework.security.authorization.DefaultAuthorizationManagerFactory;
import org.springframework.security.authorization.RequiredFactor;

public final class AuthorizationManagerFactories {
    private AuthorizationManagerFactories() {
    }

    public static <T> AdditionalRequiredFactorsBuilder<T> multiFactor() {
        return new AdditionalRequiredFactorsBuilder();
    }

    public static final class AdditionalRequiredFactorsBuilder<T> {
        private final AllRequiredFactorsAuthorizationManager.Builder<T> factors = AllRequiredFactorsAuthorizationManager.builder();

        public AdditionalRequiredFactorsBuilder<T> requireFactors(String ... additionalAuthorities) {
            this.requireFactors((AllRequiredFactorsAuthorizationManager.Builder<T> factors) -> {
                for (String authority : additionalAuthorities) {
                    factors.requireFactor(factor -> factor.authority(authority));
                }
            });
            return this;
        }

        public AdditionalRequiredFactorsBuilder<T> requireFactors(Consumer<AllRequiredFactorsAuthorizationManager.Builder<T>> factors) {
            factors.accept(this.factors);
            return this;
        }

        public AdditionalRequiredFactorsBuilder<T> requireFactor(Consumer<RequiredFactor.Builder> factor) {
            this.factors.requireFactor(factor);
            return this;
        }

        public DefaultAuthorizationManagerFactory<T> build() {
            DefaultAuthorizationManagerFactory<T> result = new DefaultAuthorizationManagerFactory<T>();
            AllRequiredFactorsAuthorizationManager<T> additionalChecks = this.factors.build();
            result.setAdditionalAuthorization(additionalChecks);
            return result;
        }

        private AdditionalRequiredFactorsBuilder() {
        }
    }
}

