/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.compendium.cm;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationPlugin;

public class CmUtils {
    private static Comparator<ServiceReference> CM_RANKING = new Comparator<ServiceReference>(){

        @Override
        public int compare(ServiceReference sr1, ServiceReference sr2) {
            long rank2;
            long rank1 = this.getLong(sr1, "service.cmRanking");
            if (rank1 == (rank2 = this.getLong(sr2, "service.cmRanking"))) {
                return 0;
            }
            return rank1 < rank2 ? -1 : 1;
        }

        protected long getLong(ServiceReference sr, String property) {
            Object rankObj = sr.getProperty(property);
            if (rankObj instanceof Number) {
                return ((Number)rankObj).longValue();
            }
            return 0L;
        }
    };

    private CmUtils() {
    }

    public static Configuration getConfiguration(ConfigurationAdmin configAdmin, String persistentId) throws IOException {
        Configuration[] configs;
        String filter = "(service.pid=" + persistentId + ')';
        try {
            configs = configAdmin.listConfigurations(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Invalid filter: " + filter);
        }
        if (configs != null && configs.length > 0) {
            return configs[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dictionary<String, Object> getProperties(ServiceReference service, String persistentId) throws IOException {
        BundleContext bc = service.getBundle().getBundleContext();
        ServiceReference caRef = bc.getServiceReference(ConfigurationAdmin.class);
        try {
            ConfigurationAdmin ca = (ConfigurationAdmin)bc.getService(caRef);
            Configuration config = CmUtils.getConfiguration(ca, persistentId);
            if (config != null) {
                BundleContext caBc;
                CaseInsensitiveDictionary props = new CaseInsensitiveDictionary(config.getProperties());
                Bundle bundle = caRef.getBundle();
                if (bundle != null && (caBc = bundle.getBundleContext()) != null) {
                    try {
                        CmUtils.callPlugins(caBc, props, service, persistentId, null);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                CaseInsensitiveDictionary caseInsensitiveDictionary = props;
                return caseInsensitiveDictionary;
            }
            Dictionary<String, Object> dictionary = null;
            return dictionary;
        }
        finally {
            bc.ungetService(caRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callPlugins(BundleContext bundleContext, Dictionary<String, Object> props, ServiceReference sr, String configPid, String factoryPid) {
        ServiceReference[] plugins = null;
        try {
            String targetPid = factoryPid == null ? configPid : factoryPid;
            String filter = "(|(!(cm.target=*))(cm.target=" + targetPid + "))";
            plugins = bundleContext.getServiceReferences(ConfigurationPlugin.class.getName(), filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (plugins == null || plugins.length == 0) {
            return;
        }
        if (plugins.length > 1) {
            Arrays.sort(plugins, CM_RANKING);
        }
        for (ServiceReference pluginRef : plugins) {
            ConfigurationPlugin plugin = (ConfigurationPlugin)bundleContext.getService(pluginRef);
            if (plugin == null) continue;
            try {
                plugin.modifyConfiguration(sr, props);
            }
            catch (Throwable throwable) {
            }
            finally {
                bundleContext.ungetService(pluginRef);
            }
            CmUtils.setAutoProperties(props, configPid, factoryPid);
        }
    }

    private static void setAutoProperties(Dictionary<String, Object> properties, String pid, String factoryPid) {
        CmUtils.replaceProperty(properties, "service.pid", pid);
        CmUtils.replaceProperty(properties, "service.factoryPid", factoryPid);
        properties.remove("service.bundleLocation");
    }

    private static void replaceProperty(Dictionary<String, Object> properties, String key, String value) {
        if (value == null) {
            properties.remove(key);
        } else {
            properties.put(key, value);
        }
    }

    private static class CaseInsensitiveDictionary
    extends Dictionary<String, Object> {
        private final Hashtable<String, Object> internalMap = new Hashtable();
        private final Hashtable<String, String> originalKeys = new Hashtable();

        public CaseInsensitiveDictionary(Dictionary<String, Object> props) {
            if (props != null) {
                Enumeration<String> keys = props.keys();
                while (keys.hasMoreElements()) {
                    String key = CaseInsensitiveDictionary.checkKey(keys.nextElement());
                    String lowerCase = key.toLowerCase();
                    if (this.internalMap.containsKey(lowerCase)) {
                        throw new IllegalArgumentException("Key [" + key + "] already present in different case");
                    }
                    Object value = props.get(key);
                    CaseInsensitiveDictionary.checkValue(value);
                    this.internalMap.put(lowerCase, value);
                    this.originalKeys.put(lowerCase, key);
                }
            }
        }

        @Override
        public Enumeration<Object> elements() {
            return Collections.enumeration(this.internalMap.values());
        }

        @Override
        public Object get(Object keyObj) {
            String lowerCase = CaseInsensitiveDictionary.checkKey(keyObj == null ? null : keyObj.toString()).toLowerCase();
            return this.internalMap.get(lowerCase);
        }

        @Override
        public boolean isEmpty() {
            return this.internalMap.isEmpty();
        }

        @Override
        public Enumeration<String> keys() {
            return Collections.enumeration(this.originalKeys.values());
        }

        @Override
        public Object put(String key, Object value) {
            String lowerCase = CaseInsensitiveDictionary.checkKey(key).toLowerCase();
            CaseInsensitiveDictionary.checkValue(value);
            this.originalKeys.put(lowerCase, key);
            return this.internalMap.put(lowerCase, value);
        }

        @Override
        public Object remove(Object keyObj) {
            String lowerCase = CaseInsensitiveDictionary.checkKey(keyObj == null ? null : keyObj.toString()).toLowerCase();
            this.originalKeys.remove(lowerCase);
            return this.internalMap.remove(lowerCase);
        }

        @Override
        public int size() {
            return this.internalMap.size();
        }

        static String checkKey(String key) {
            if (key == null || key.length() == 0) {
                throw new IllegalArgumentException("Key must not be null nor an empty string");
            }
            return key;
        }

        static Object checkValue(Object value) {
            if (value == null) {
                throw new IllegalArgumentException("Value must not be null");
            }
            return value;
        }

        public String toString() {
            return this.internalMap.toString();
        }
    }
}

