/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.InvalidLogBufferException;
import org.objectweb.howl.log.LogFile;
import org.objectweb.howl.log.LogFileManager;
import org.objectweb.howl.log.LogFileOverflowException;
import org.objectweb.howl.log.LogObject;
import org.objectweb.howl.log.LogRecordSizeException;

abstract class LogBuffer
extends LogObject {
    final ByteBuffer buffer;
    int index = -1;
    long tod = 0L;
    protected int waitingThreads = 0;
    final Object waitingThreadsLock = new Object();
    int iostatus = 0;
    int bsn = 0;
    boolean rewind = false;
    boolean forceNow = false;
    IOException ioexception = null;
    String name = this.getClass().getName();
    LogFile lf = null;
    boolean doChecksum = true;
    int bytesUsed = 0;
    byte[] checksumBuffer = null;
    final Adler32 checksum;

    LogBuffer(Configuration config) {
        super(config);
        this.doChecksum = config.isChecksumEnabled();
        this.buffer = ByteBuffer.allocateDirect(config.getBufferSize() * 1024);
        this.checksum = this.doChecksum && config.isAdler32ChecksumEnabled() ? new Adler32() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int release() {
        Object object = this.waitingThreadsLock;
        synchronized (object) {
            return --this.waitingThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getWaitingThreads() {
        Object object = this.waitingThreadsLock;
        synchronized (object) {
            return this.waitingThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sync() throws IOException, InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        LogBuffer logBuffer = this;
        synchronized (logBuffer) {
            while (this.iostatus != 2) {
                if (this.iostatus == 3) {
                    throw new IOException("LogBuffer.sync(): LogBufferStatus.ERROR");
                }
                this.wait();
            }
        }
    }

    int checksum() {
        int result = 0;
        this.buffer.clear();
        if (this.checksum == null) {
            result = this.buffer.hashCode();
        } else {
            byte[] checksumBuffer;
            if (this.buffer.hasArray()) {
                checksumBuffer = this.buffer.array();
            } else {
                if (this.checksumBuffer == null) {
                    this.checksumBuffer = new byte[this.buffer.capacity()];
                }
                checksumBuffer = this.checksumBuffer;
                this.buffer.get(checksumBuffer);
            }
            this.checksum.reset();
            this.checksum.update(checksumBuffer, 0, checksumBuffer.length);
            result = (int)(this.checksum.getValue() & 0xFFFFFFFFFFFFFFFFL);
        }
        return result;
    }

    String getName() {
        return "(" + this.name + ")";
    }

    abstract LogBuffer init(int var1, LogFileManager var2) throws LogFileOverflowException;

    abstract LogBuffer read(LogFile var1, long var2) throws IOException, InvalidLogBufferException;

    abstract boolean shouldForce();

    abstract long put(short var1, byte[][] var2, boolean var3) throws LogRecordSizeException;

    abstract void write() throws IOException;

    abstract String getStats();
}

