/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CapReq {
    private final MODE mode;
    private final String namespace;
    private final Resource resource;
    private final Map<String, String> directives;
    private final Map<String, Object> attributes;

    CapReq(MODE mode, String namespace, Resource resource, Map<String, String> directives, Map<String, Object> attributes) {
        this.mode = mode;
        this.namespace = namespace;
        this.resource = resource;
        this.directives = new HashMap<String, String>(directives);
        this.attributes = new HashMap<String, Object>(attributes);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, String> getDirectives() {
        return Collections.unmodifiableMap(this.directives);
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public Resource getResource() {
        return this.resource;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.directives == null ? 0 : this.directives.hashCode());
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CapReq other = (CapReq)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.directives == null ? other.directives != null : !this.directives.equals(other.directives)) {
            return false;
        }
        if (this.mode != other.mode) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        return !(this.resource == null ? other.resource != null : !this.resource.equals((Object)other.resource));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.mode == MODE.Capability) {
            Object value = this.attributes.get(this.namespace);
            builder.append(this.namespace).append('=').append(value);
        } else {
            String filter = this.directives.get("filter");
            builder.append(filter);
            if ("optional".equals(this.directives.get("resolution"))) {
                builder.append("%OPT");
            }
        }
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MODE {
        Capability,
        Requirement;

    }
}

