/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.internal;

import java.util.concurrent.TimeUnit;
import org.apache.karaf.main.internal.SystemdDaemon;

public class Systemd {
    public static final String ENV_WATCHDOG_USEC = "WATCHDOG_USEC";
    public static final String ENV_MAIN_PID = "SYSTEMD_MAIN_PID";
    private final String mainPid = System.getProperty("karaf.systemd.main.pid", System.getenv("SYSTEMD_MAIN_PID"));

    public int notifyWatchdog() {
        int rc = -1;
        if (SystemdDaemon.INSTANCE != null) {
            rc = SystemdDaemon.INSTANCE.sd_notify(0, this.mainPid == null ? "WATCHDOG=1" : "MAINPID=" + this.mainPid + "\nWATCHDOG=1");
        }
        return rc;
    }

    public long getWatchdogTimeout(TimeUnit timeUnit) {
        String timeouts = System.getenv(ENV_WATCHDOG_USEC);
        if (timeouts != null) {
            long micros = Long.parseLong(timeouts);
            return timeUnit.convert(micros, TimeUnit.MICROSECONDS);
        }
        return -1L;
    }
}

