/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionTaskStage;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.TsFileIdentifier;

public class CompactionLogAnalyzer {
    private final File logFile;
    private final List<TsFileIdentifier> sourceFileInfos = new ArrayList<TsFileIdentifier>();
    private final List<TsFileIdentifier> targetFileInfos = new ArrayList<TsFileIdentifier>();
    private final List<TsFileIdentifier> deletedTargetFileInfos = new ArrayList<TsFileIdentifier>();
    private CompactionTaskStage taskStage;

    public CompactionLogAnalyzer(File logFile) {
        this.logFile = logFile;
    }

    public void analyze() throws IOException, IllegalArgumentException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFile));){
            String currLine;
            while ((currLine = bufferedReader.readLine()) != null) {
                String fileInfo;
                String lineValue = currLine;
                if (currLine.startsWith("source")) {
                    fileInfo = currLine.replaceFirst("source ", "");
                    this.sourceFileInfos.add(TsFileIdentifier.getFileIdentifierFromInfoString(fileInfo));
                    continue;
                }
                if (currLine.startsWith("target")) {
                    fileInfo = currLine.replaceFirst("target ", "");
                    this.targetFileInfos.add(TsFileIdentifier.getFileIdentifierFromInfoString(fileInfo));
                    continue;
                }
                if (currLine.startsWith("empty")) {
                    fileInfo = currLine.replaceFirst("empty ", "");
                    this.deletedTargetFileInfos.add(TsFileIdentifier.getFileIdentifierFromInfoString(fileInfo));
                    continue;
                }
                if (Stream.of(CompactionTaskStage.values()).anyMatch(stage -> lineValue.startsWith(stage.name()))) {
                    this.taskStage = CompactionTaskStage.valueOf(currLine);
                    continue;
                }
                throw new IllegalArgumentException(String.format("unknown compaction log line: %s", currLine));
            }
        }
    }

    public List<TsFileIdentifier> getSourceFileInfos() {
        return this.sourceFileInfos;
    }

    public List<TsFileIdentifier> getTargetFileInfos() {
        return this.targetFileInfos;
    }

    public List<TsFileIdentifier> getDeletedTargetFileInfos() {
        return this.deletedTargetFileInfos;
    }

    public CompactionTaskStage getTaskStage() {
        return this.taskStage;
    }
}

