/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.iceberg;

import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.catalog.CatalogPrefixParser;
import org.apache.polaris.service.catalog.api.IcebergRestCatalogApiService;
import org.apache.polaris.service.catalog.common.CatalogAdapter;
import org.apache.polaris.service.catalog.iceberg.IcebergCatalogAdapter;
import org.apache.polaris.service.events.IcebergRestCatalogEvents;
import org.apache.polaris.service.events.listeners.PolarisEventListener;
import org.apache.polaris.service.types.CommitTableRequest;
import org.apache.polaris.service.types.CommitViewRequest;
import org.apache.polaris.service.types.NotificationRequest;

@Decorator
@Priority(value=1000)
public class IcebergRestCatalogEventServiceDelegator
implements IcebergRestCatalogApiService,
CatalogAdapter {
    @Inject
    @Delegate
    IcebergCatalogAdapter delegate;
    @Inject
    PolarisEventListener polarisEventListener;
    @Inject
    CatalogPrefixParser prefixParser;

    public Response createNamespace(String prefix, CreateNamespaceRequest createNamespaceRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeCreateNamespace(new IcebergRestCatalogEvents.BeforeCreateNamespaceEvent(catalogName, createNamespaceRequest));
        Response resp = this.delegate.createNamespace(prefix, createNamespaceRequest, realmContext, securityContext);
        CreateNamespaceResponse createNamespaceResponse = (CreateNamespaceResponse)resp.getEntity();
        this.polarisEventListener.onAfterCreateNamespace(new IcebergRestCatalogEvents.AfterCreateNamespaceEvent(catalogName, createNamespaceResponse.namespace(), createNamespaceResponse.properties()));
        return resp;
    }

    public Response listNamespaces(String prefix, String pageToken, Integer pageSize, String parent, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeListNamespaces(new IcebergRestCatalogEvents.BeforeListNamespacesEvent(catalogName, parent));
        Response resp = this.delegate.listNamespaces(prefix, pageToken, pageSize, parent, realmContext, securityContext);
        this.polarisEventListener.onAfterListNamespaces(new IcebergRestCatalogEvents.AfterListNamespacesEvent(catalogName, parent));
        return resp;
    }

    public Response loadNamespaceMetadata(String prefix, String namespace, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeLoadNamespaceMetadata(new IcebergRestCatalogEvents.BeforeLoadNamespaceMetadataEvent(catalogName, this.decodeNamespace(namespace)));
        Response resp = this.delegate.loadNamespaceMetadata(prefix, namespace, realmContext, securityContext);
        GetNamespaceResponse getNamespaceResponse = (GetNamespaceResponse)resp.getEntity();
        this.polarisEventListener.onAfterLoadNamespaceMetadata(new IcebergRestCatalogEvents.AfterLoadNamespaceMetadataEvent(catalogName, getNamespaceResponse.namespace(), getNamespaceResponse.properties()));
        return resp;
    }

    public Response namespaceExists(String prefix, String namespace, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeCheckExistsNamespace(new IcebergRestCatalogEvents.BeforeCheckExistsNamespaceEvent(catalogName, namespaceObj));
        Response resp = this.delegate.namespaceExists(prefix, namespace, realmContext, securityContext);
        this.polarisEventListener.onAfterCheckExistsNamespace(new IcebergRestCatalogEvents.AfterCheckExistsNamespaceEvent(catalogName, namespaceObj));
        return resp;
    }

    public Response dropNamespace(String prefix, String namespace, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeDropNamespace(new IcebergRestCatalogEvents.BeforeDropNamespaceEvent(catalogName, this.decodeNamespace(namespace)));
        Response resp = this.delegate.dropNamespace(prefix, namespace, realmContext, securityContext);
        this.polarisEventListener.onAfterDropNamespace(new IcebergRestCatalogEvents.AfterDropNamespaceEvent(catalogName, namespace));
        return resp;
    }

    public Response updateProperties(String prefix, String namespace, UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeUpdateNamespaceProperties(new IcebergRestCatalogEvents.BeforeUpdateNamespacePropertiesEvent(catalogName, namespaceObj, updateNamespacePropertiesRequest));
        Response resp = this.delegate.updateProperties(prefix, namespace, updateNamespacePropertiesRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterUpdateNamespaceProperties(new IcebergRestCatalogEvents.AfterUpdateNamespacePropertiesEvent(catalogName, namespaceObj, (UpdateNamespacePropertiesResponse)resp.getEntity()));
        return resp;
    }

    public Response createTable(String prefix, String namespace, CreateTableRequest createTableRequest, String accessDelegationMode, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeCreateTable(new IcebergRestCatalogEvents.BeforeCreateTableEvent(catalogName, namespaceObj, createTableRequest, accessDelegationMode));
        Response resp = this.delegate.createTable(prefix, namespace, createTableRequest, accessDelegationMode, realmContext, securityContext);
        if (!createTableRequest.stageCreate()) {
            this.polarisEventListener.onAfterCreateTable(new IcebergRestCatalogEvents.AfterCreateTableEvent(catalogName, namespaceObj, createTableRequest.name(), (LoadTableResponse)resp.getEntity()));
        }
        return resp;
    }

    public Response listTables(String prefix, String namespace, String pageToken, Integer pageSize, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeListTables(new IcebergRestCatalogEvents.BeforeListTablesEvent(catalogName, namespaceObj));
        Response resp = this.delegate.listTables(prefix, namespace, pageToken, pageSize, realmContext, securityContext);
        this.polarisEventListener.onAfterListTables(new IcebergRestCatalogEvents.AfterListTablesEvent(catalogName, namespaceObj));
        return resp;
    }

    public Response loadTable(String prefix, String namespace, String table, String accessDelegationMode, String ifNoneMatchString, String snapshots, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeLoadTable(new IcebergRestCatalogEvents.BeforeLoadTableEvent(catalogName, namespaceObj, table, accessDelegationMode, ifNoneMatchString, snapshots));
        Response resp = this.delegate.loadTable(prefix, namespace, table, accessDelegationMode, ifNoneMatchString, snapshots, realmContext, securityContext);
        this.polarisEventListener.onAfterLoadTable(new IcebergRestCatalogEvents.AfterLoadTableEvent(catalogName, namespaceObj, table, (LoadTableResponse)resp.getEntity()));
        return resp;
    }

    public Response tableExists(String prefix, String namespace, String table, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeCheckExistsTable(new IcebergRestCatalogEvents.BeforeCheckExistsTableEvent(catalogName, namespaceObj, table));
        Response resp = this.delegate.tableExists(prefix, namespace, table, realmContext, securityContext);
        this.polarisEventListener.onAfterCheckExistsTable(new IcebergRestCatalogEvents.AfterCheckExistsTableEvent(catalogName, namespaceObj, table));
        return resp;
    }

    public Response dropTable(String prefix, String namespace, String table, Boolean purgeRequested, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeDropTable(new IcebergRestCatalogEvents.BeforeDropTableEvent(catalogName, namespaceObj, table, purgeRequested));
        Response resp = this.delegate.dropTable(prefix, namespace, table, purgeRequested, realmContext, securityContext);
        this.polarisEventListener.onAfterDropTable(new IcebergRestCatalogEvents.AfterDropTableEvent(catalogName, namespaceObj, table, purgeRequested));
        return resp;
    }

    public Response registerTable(String prefix, String namespace, RegisterTableRequest registerTableRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeRegisterTable(new IcebergRestCatalogEvents.BeforeRegisterTableEvent(catalogName, namespaceObj, registerTableRequest));
        Response resp = this.delegate.registerTable(prefix, namespace, registerTableRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterRegisterTable(new IcebergRestCatalogEvents.AfterRegisterTableEvent(catalogName, namespaceObj, registerTableRequest.name(), (LoadTableResponse)resp.getEntity()));
        return resp;
    }

    public Response renameTable(String prefix, RenameTableRequest renameTableRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeRenameTable(new IcebergRestCatalogEvents.BeforeRenameTableEvent(catalogName, renameTableRequest));
        Response resp = this.delegate.renameTable(prefix, renameTableRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterRenameTable(new IcebergRestCatalogEvents.AfterRenameTableEvent(catalogName, renameTableRequest));
        return resp;
    }

    public Response updateTable(String prefix, String namespace, String table, CommitTableRequest commitTableRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeUpdateTable(new IcebergRestCatalogEvents.BeforeUpdateTableEvent(catalogName, namespaceObj, table, commitTableRequest));
        Response resp = this.delegate.updateTable(prefix, namespace, table, commitTableRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterUpdateTable(new IcebergRestCatalogEvents.AfterUpdateTableEvent(catalogName, namespaceObj, table, commitTableRequest, (LoadTableResponse)resp.getEntity()));
        return resp;
    }

    public Response createView(String prefix, String namespace, CreateViewRequest createViewRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeCreateView(new IcebergRestCatalogEvents.BeforeCreateViewEvent(catalogName, namespaceObj, createViewRequest));
        Response resp = this.delegate.createView(prefix, namespace, createViewRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterCreateView(new IcebergRestCatalogEvents.AfterCreateViewEvent(catalogName, namespaceObj, createViewRequest.name(), (LoadViewResponse)resp.getEntity()));
        return resp;
    }

    public Response listViews(String prefix, String namespace, String pageToken, Integer pageSize, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeListViews(new IcebergRestCatalogEvents.BeforeListViewsEvent(catalogName, namespaceObj));
        Response resp = this.delegate.listViews(prefix, namespace, pageToken, pageSize, realmContext, securityContext);
        this.polarisEventListener.onAfterListViews(new IcebergRestCatalogEvents.AfterListViewsEvent(catalogName, namespaceObj));
        return resp;
    }

    public Response loadCredentials(String prefix, String namespace, String table, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeLoadCredentials(new IcebergRestCatalogEvents.BeforeLoadCredentialsEvent(catalogName, namespaceObj, table));
        Response resp = this.delegate.loadCredentials(prefix, namespace, table, realmContext, securityContext);
        this.polarisEventListener.onAfterLoadCredentials(new IcebergRestCatalogEvents.AfterLoadCredentialsEvent(catalogName, namespaceObj, table));
        return resp;
    }

    public Response loadView(String prefix, String namespace, String view, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeLoadView(new IcebergRestCatalogEvents.BeforeLoadViewEvent(catalogName, namespaceObj, view));
        Response resp = this.delegate.loadView(prefix, namespace, view, realmContext, securityContext);
        this.polarisEventListener.onAfterLoadView(new IcebergRestCatalogEvents.AfterLoadViewEvent(catalogName, namespaceObj, view, (LoadViewResponse)resp.getEntity()));
        return resp;
    }

    public Response viewExists(String prefix, String namespace, String view, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeCheckExistsView(new IcebergRestCatalogEvents.BeforeCheckExistsViewEvent(catalogName, namespaceObj, view));
        Response resp = this.delegate.viewExists(prefix, namespace, view, realmContext, securityContext);
        this.polarisEventListener.onAfterCheckExistsView(new IcebergRestCatalogEvents.AfterCheckExistsViewEvent(catalogName, namespaceObj, view));
        return resp;
    }

    public Response dropView(String prefix, String namespace, String view, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeDropView(new IcebergRestCatalogEvents.BeforeDropViewEvent(catalogName, namespaceObj, view));
        Response resp = this.delegate.dropView(prefix, namespace, view, realmContext, securityContext);
        this.polarisEventListener.onAfterDropView(new IcebergRestCatalogEvents.AfterDropViewEvent(catalogName, namespaceObj, view));
        return resp;
    }

    public Response renameView(String prefix, RenameTableRequest renameTableRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeRenameView(new IcebergRestCatalogEvents.BeforeRenameViewEvent(catalogName, renameTableRequest));
        Response resp = this.delegate.renameView(prefix, renameTableRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterRenameView(new IcebergRestCatalogEvents.AfterRenameViewEvent(catalogName, renameTableRequest));
        return resp;
    }

    public Response replaceView(String prefix, String namespace, String view, CommitViewRequest commitViewRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeReplaceView(new IcebergRestCatalogEvents.BeforeReplaceViewEvent(catalogName, namespaceObj, view, commitViewRequest));
        Response resp = this.delegate.replaceView(prefix, namespace, view, commitViewRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterReplaceView(new IcebergRestCatalogEvents.AfterReplaceViewEvent(catalogName, namespaceObj, view, commitViewRequest, (LoadViewResponse)resp.getEntity()));
        return resp;
    }

    public Response commitTransaction(String prefix, CommitTransactionRequest commitTransactionRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeCommitTransaction(new IcebergRestCatalogEvents.BeforeCommitTransactionEvent(catalogName, commitTransactionRequest));
        Response resp = this.delegate.commitTransaction(prefix, commitTransactionRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterCommitTransaction(new IcebergRestCatalogEvents.AfterCommitTransactionEvent(catalogName, commitTransactionRequest));
        return resp;
    }

    public Response reportMetrics(String prefix, String namespace, String table, ReportMetricsRequest reportMetricsRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.reportMetrics(prefix, namespace, table, reportMetricsRequest, realmContext, securityContext);
    }

    public Response sendNotification(String prefix, String namespace, String table, NotificationRequest notificationRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        Namespace namespaceObj = this.decodeNamespace(namespace);
        this.polarisEventListener.onBeforeSendNotification(new IcebergRestCatalogEvents.BeforeSendNotificationEvent(catalogName, namespaceObj, table, notificationRequest));
        Response resp = this.delegate.sendNotification(prefix, namespace, table, notificationRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterSendNotification(new IcebergRestCatalogEvents.AfterSendNotificationEvent(catalogName, namespaceObj, table));
        return resp;
    }
}

