/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import java.util.regex.Pattern;

public class HostHeaderHandler
implements HttpHandler {
    public static final HandlerWrapper WRAPPER;
    public static final String STATUS_NO_HOST_HEADER = "No Host Header";
    public static final String STATUS_TOO_MANY_HOST_HEADERS = "Only One Host Header Allowed";
    public static final String STATUS_MALFORMED_PORT = "Host Header Malformed Port";
    public static final String STATUS_MALFORMED_IP_LITERAL = "Host Header Malformed IP-Literal";
    public static final String STATUS_MALFORMED_IP_LITERAL_BAD_CHARS = "Host Header Bad Characters";
    public static final String STATUS_HOST_NO_MATCH = "URI Host Header NO MATCH";
    private static final Pattern IP4_EXACT;
    private static final Pattern IP6_EXACT;
    private static final boolean[] ALLOWED_REGNAME_CHARACTERS;
    private static final boolean[] HEX_CHARACTERS;
    private static final boolean[] ALLOWED_IPv_FUTURE_CHARACTERS;
    private final HttpHandler next;

    public HostHeaderHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String hostHeaderURI;
        int lastColonIndex;
        HeaderMap headerMap = exchange.getRequestHeaders();
        HeaderValues headerValues = headerMap.get(Headers.HOST);
        HttpString protocol = exchange.getProtocol();
        if ((protocol.equals(Protocols.HTTP_0_9) || protocol.equals(Protocols.HTTP_1_0)) && headerValues == null) {
            this.next.handleRequest(exchange);
            return;
        }
        if (headerValues == null || headerValues.size() == 0) {
            this.terminate(exchange, STATUS_NO_HOST_HEADER);
            return;
        }
        if (headerValues.size() > 1) {
            this.terminate(exchange, STATUS_TOO_MANY_HOST_HEADERS);
            return;
        }
        String headerValue = headerValues.element();
        int rightBracketIndex = headerValue.lastIndexOf(93);
        if (rightBracketIndex < (lastColonIndex = headerValue.lastIndexOf(58))) {
            if (rightBracketIndex == -1 && headerValue.startsWith("[")) {
                this.terminate(exchange, STATUS_MALFORMED_IP_LITERAL);
                return;
            }
            String portString = headerValue.substring(lastColonIndex + 1);
            try {
                int port = Integer.parseInt(portString);
                if (port <= 0 || port > 65535) {
                    this.terminate(exchange, STATUS_MALFORMED_PORT);
                    return;
                }
            }
            catch (NumberFormatException nfe) {
                this.terminate(exchange, STATUS_MALFORMED_PORT);
                return;
            }
            hostHeaderURI = headerValue.substring(0, lastColonIndex);
        } else {
            hostHeaderURI = headerValue;
        }
        if (rightBracketIndex > 0 && hostHeaderURI.indexOf(91) != 0) {
            this.terminate(exchange, STATUS_MALFORMED_IP_LITERAL);
            return;
        }
        if (rightBracketIndex > 0 && hostHeaderURI.indexOf(91) == 0) {
            String debracked = hostHeaderURI.substring(1, hostHeaderURI.length() - 1);
            if (debracked.startsWith("v")) {
                int i;
                int dotIndex = debracked.indexOf(".");
                if (dotIndex < 2) {
                    this.terminate(exchange, STATUS_MALFORMED_IP_LITERAL);
                    return;
                }
                String hex = debracked.substring(1, dotIndex);
                for (i = 0; i < hex.length(); ++i) {
                    char c1 = hex.charAt(i);
                    if (HEX_CHARACTERS[c1]) continue;
                    this.terminate(exchange, STATUS_MALFORMED_IP_LITERAL_BAD_CHARS);
                    return;
                }
                if (dotIndex + 1 >= debracked.length()) {
                    this.terminate(exchange, STATUS_MALFORMED_IP_LITERAL);
                    return;
                }
                for (i = dotIndex + 1; i < debracked.length(); ++i) {
                    char c = debracked.charAt(i);
                    if (ALLOWED_IPv_FUTURE_CHARACTERS[c]) continue;
                    this.terminate(exchange, STATUS_MALFORMED_IP_LITERAL_BAD_CHARS);
                    return;
                }
            } else if (!IP6_EXACT.matcher(debracked).matches()) {
                this.terminate(exchange, STATUS_MALFORMED_IP_LITERAL);
                return;
            }
        } else if (!IP4_EXACT.matcher(hostHeaderURI).matches()) {
            for (int index = 0; index < hostHeaderURI.length(); ++index) {
                char c = hostHeaderURI.charAt(index);
                if (c == '%') {
                    if (index + 2 < hostHeaderURI.length()) {
                        char c1 = hostHeaderURI.charAt(++index);
                        char c2 = hostHeaderURI.charAt(++index);
                        if (HEX_CHARACTERS[c1] && HEX_CHARACTERS[c2]) continue;
                        this.terminate(exchange, STATUS_MALFORMED_IP_LITERAL_BAD_CHARS);
                        return;
                    }
                    this.terminate(exchange, STATUS_MALFORMED_IP_LITERAL);
                    return;
                }
                if (ALLOWED_REGNAME_CHARACTERS[c]) continue;
                this.terminate(exchange, STATUS_MALFORMED_IP_LITERAL_BAD_CHARS);
                return;
            }
        }
        if (exchange.isHostIncludedInRequestURI()) {
            if (!exchange.getRequestURI().contains(hostHeaderURI)) {
                this.terminate(exchange, STATUS_HOST_NO_MATCH);
                return;
            }
            if (hostHeaderURI.isEmpty()) {
                this.terminate(exchange, STATUS_HOST_NO_MATCH);
                return;
            }
        }
        this.next.handleRequest(exchange);
    }

    private void terminate(HttpServerExchange exchange, String message) {
        exchange.setStatusCode(400);
        exchange.setResponseContentLength(0L);
        exchange.getResponseHeaders().add(Headers.CONNECTION, Headers.CLOSE.toString());
        exchange.setReasonPhrase(message);
        exchange.endExchange();
    }

    static {
        int i;
        WRAPPER = new Wrapper();
        IP4_EXACT = Pattern.compile("(?:(25[0-5]|(?:2[0-4]|(?:(1{0,1}[0-9]))){0,1}(?:([0-9])))\\.){3,3}(?:(25[0-5]|(?:2[0-4]|(?:(1{0,1}[0-9]))){0,1}(?:([0-9]))))");
        IP6_EXACT = Pattern.compile("^(?:([0-9a-fA-F]{1,4}:){7,7}(?:[0-9a-fA-F]){1,4}|(?:([0-9a-fA-F]{1,4}:)){1,7}(?:(:))|(?:([0-9a-fA-F]{1,4}:)){1,6}(?:(:[0-9a-fA-F]){1,4})|(?:([0-9a-fA-F]{1,4}:)){1,5}(?:(:[0-9a-fA-F]{1,4})){1,2}|(?:([0-9a-fA-F]{1,4}:)){1,4}(?:(:[0-9a-fA-F]{1,4})){1,3}|(?:([0-9a-fA-F]{1,4}:)){1,3}(?:(:[0-9a-fA-F]{1,4})){1,4}|(?:([0-9a-fA-F]{1,4}:)){1,2}(?:(:[0-9a-fA-F]{1,4})){1,5}|(?:([0-9a-fA-F]{1,4}:))(?:(:[0-9a-fA-F]{1,4})){1,6}|(?:(:))(?:((:[0-9a-fA-F]{1,4}){1,7}|(?:(:))))|(?:([0-9a-fA-F]{1,4}:)){1,4}(?:(:(?:(25[0-5]|(?:2[0-4]|(?:(1{0,1}[0-9]))){0,1}(?:([0-9])))\\.){3,3}(?:(25[0-5]|(?:2[0-4]|(?:(1{0,1}[0-9]))){0,1}(?:([0-9])))))))$");
        ALLOWED_REGNAME_CHARACTERS = new boolean[256];
        HEX_CHARACTERS = new boolean[256];
        ALLOWED_IPv_FUTURE_CHARACTERS = new boolean[256];
        block3: for (i = 0; i < ALLOWED_REGNAME_CHARACTERS.length; ++i) {
            if (i >= 48 && i <= 57 || i >= 97 && i <= 122 || i >= 65 && i <= 90) {
                HostHeaderHandler.ALLOWED_REGNAME_CHARACTERS[i] = true;
                HostHeaderHandler.ALLOWED_IPv_FUTURE_CHARACTERS[i] = true;
                continue;
            }
            switch (i) {
                case 33: 
                case 36: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 59: 
                case 61: 
                case 95: 
                case 126: {
                    HostHeaderHandler.ALLOWED_REGNAME_CHARACTERS[i] = true;
                    HostHeaderHandler.ALLOWED_IPv_FUTURE_CHARACTERS[i] = true;
                    continue block3;
                }
                default: {
                    HostHeaderHandler.ALLOWED_REGNAME_CHARACTERS[i] = false;
                    HostHeaderHandler.ALLOWED_IPv_FUTURE_CHARACTERS[i] = false;
                }
            }
        }
        HostHeaderHandler.ALLOWED_IPv_FUTURE_CHARACTERS[58] = true;
        for (i = 0; i < HEX_CHARACTERS.length; ++i) {
            HostHeaderHandler.HEX_CHARACTERS[i] = i >= 48 && i <= 57 || i >= 97 && i <= 102 || i >= 65 && i <= 70;
        }
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new HostHeaderHandler(handler);
        }
    }
}

