/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import io.undertow.server.handlers.Cookie;

public final class LegacyCookieSupport {
    static final boolean ALLOW_HTTP_SEPARATORS_IN_V0 = Boolean.getBoolean("io.undertow.legacy.cookie.ALLOW_HTTP_SEPARATORS_IN_V0");
    private static final boolean FWD_SLASH_IS_SEPARATOR = Boolean.getBoolean("io.undertow.legacy.cookie.FWD_SLASH_IS_SEPARATOR");
    static final boolean COMMA_IS_SEPARATOR = Boolean.getBoolean("io.undertow.legacy.cookie.COMMA_IS_SEPARATOR");
    private static final char[] V0_SEPARATORS = new char[]{',', ';', ' ', '\t'};
    private static final boolean[] V0_SEPARATOR_FLAGS = new boolean[128];
    private static final char[] HTTP_SEPARATORS;
    private static final boolean[] HTTP_SEPARATOR_FLAGS;

    private static boolean isV0Separator(char c) {
        if ((c < ' ' || c >= '\u007f') && c != '\t') {
            throw UndertowMessages.MESSAGES.invalidControlCharacter(Integer.toString(c));
        }
        return V0_SEPARATOR_FLAGS[c];
    }

    private static boolean isV0Token(String value) {
        if (value == null) {
            return false;
        }
        int i = 0;
        int len = value.length();
        if (LegacyCookieSupport.alreadyQuoted(value)) {
            ++i;
            --len;
        }
        while (i < len) {
            char c = value.charAt(i);
            if (LegacyCookieSupport.isV0Separator(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean isHttpSeparator(char c) {
        if ((c < ' ' || c >= '\u007f') && c != '\t') {
            throw UndertowMessages.MESSAGES.invalidControlCharacter(Integer.toString(c));
        }
        return HTTP_SEPARATOR_FLAGS[c];
    }

    private static boolean isHttpToken(String value) {
        if (value == null) {
            return false;
        }
        int i = 0;
        int len = value.length();
        if (LegacyCookieSupport.alreadyQuoted(value)) {
            ++i;
            --len;
        }
        while (i < len) {
            char c = value.charAt(i);
            if (LegacyCookieSupport.isHttpSeparator(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean alreadyQuoted(String value) {
        if (value == null || value.length() < 2) {
            return false;
        }
        return value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    public static void maybeQuote(StringBuilder buf, String value) {
        if (value == null || value.length() == 0) {
            buf.append("\"\"");
        } else if (LegacyCookieSupport.alreadyQuoted(value)) {
            buf.append('\"');
            buf.append(LegacyCookieSupport.escapeDoubleQuotes(value, 1, value.length() - 1));
            buf.append('\"');
        } else if (LegacyCookieSupport.isHttpToken(value) && !ALLOW_HTTP_SEPARATORS_IN_V0 || LegacyCookieSupport.isV0Token(value) && ALLOW_HTTP_SEPARATORS_IN_V0) {
            buf.append('\"');
            buf.append(LegacyCookieSupport.escapeDoubleQuotes(value, 0, value.length()));
            buf.append('\"');
        } else {
            buf.append(value);
        }
    }

    private static String escapeDoubleQuotes(String s, int beginIndex, int endIndex) {
        if (s == null || s.length() == 0 || s.indexOf(34) == -1) {
            return s;
        }
        StringBuilder b = new StringBuilder();
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                b.append(c);
                if (++i >= endIndex) {
                    throw UndertowMessages.MESSAGES.invalidEscapeCharacter();
                }
                b.append(s.charAt(i));
                continue;
            }
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static int adjustedCookieVersion(Cookie cookie) {
        int version = cookie.getVersion();
        String value = cookie.getValue();
        String path = cookie.getPath();
        String domain = cookie.getDomain();
        String comment = cookie.getComment();
        if (version == 0 && (!ALLOW_HTTP_SEPARATORS_IN_V0 && LegacyCookieSupport.isHttpToken(value) || ALLOW_HTTP_SEPARATORS_IN_V0 && LegacyCookieSupport.isV0Token(value))) {
            version = 1;
        }
        if (version == 0 && comment != null) {
            version = 1;
        }
        if (version == 0 && (!ALLOW_HTTP_SEPARATORS_IN_V0 && LegacyCookieSupport.isHttpToken(path) || ALLOW_HTTP_SEPARATORS_IN_V0 && LegacyCookieSupport.isV0Token(path))) {
            version = 1;
        }
        if (version == 0 && (!ALLOW_HTTP_SEPARATORS_IN_V0 && LegacyCookieSupport.isHttpToken(domain) || ALLOW_HTTP_SEPARATORS_IN_V0 && LegacyCookieSupport.isV0Token(domain))) {
            version = 1;
        }
        return version;
    }

    private LegacyCookieSupport() {
    }

    static {
        HTTP_SEPARATOR_FLAGS = new boolean[128];
        HTTP_SEPARATORS = FWD_SLASH_IS_SEPARATOR ? new char[]{'\t', ' ', '\"', '(', ')', ',', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '{', '}'} : new char[]{'\t', ' ', '\"', '(', ')', ',', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '{', '}'};
        for (int i = 0; i < 128; ++i) {
            LegacyCookieSupport.V0_SEPARATOR_FLAGS[i] = false;
            LegacyCookieSupport.HTTP_SEPARATOR_FLAGS[i] = false;
        }
        for (char V0_SEPARATOR : V0_SEPARATORS) {
            LegacyCookieSupport.V0_SEPARATOR_FLAGS[V0_SEPARATOR] = true;
        }
        for (char HTTP_SEPARATOR : HTTP_SEPARATORS) {
            LegacyCookieSupport.HTTP_SEPARATOR_FLAGS[HTTP_SEPARATOR] = true;
        }
    }
}

