/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context.creational;

import jakarta.enterprise.context.spi.Contextual;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.util.WebBeansUtil;

public class DependentCreationalContext<S>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Contextual<S> contextual;
    private Object instance;

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    public DependentCreationalContext(Contextual<S> contextual) {
        this.contextual = contextual;
    }

    public Contextual<S> getContextual() {
        return this.contextual;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.instance);
        if (this.contextual != null) {
            String id = WebBeansUtil.getPassivationId(this.contextual);
            if (id == null) throw new NotSerializableException("cannot serialize " + this.contextual.toString());
            s.writeObject(id);
            return;
        } else {
            s.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.instance = s.readObject();
        String id = (String)s.readObject();
        if (id != null) {
            WebBeansContext webBeansContext = WebBeansContext.currentInstance();
            this.contextual = webBeansContext.getBeanManagerImpl().getPassivationCapableBean(id);
        }
    }
}

