/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailableSpaceVolumeChoosingPolicy<V extends FsVolumeSpi>
implements VolumeChoosingPolicy<V>,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(AvailableSpaceVolumeChoosingPolicy.class);
    private Object[] syncLocks;
    private final Random random;
    private long balancedSpaceThreshold = 0x280000000L;
    private float balancedPreferencePercent = 0.75f;
    private final VolumeChoosingPolicy<V> roundRobinPolicyBalanced = new RoundRobinVolumeChoosingPolicy();
    private final VolumeChoosingPolicy<V> roundRobinPolicyHighAvailable = new RoundRobinVolumeChoosingPolicy();
    private final VolumeChoosingPolicy<V> roundRobinPolicyLowAvailable = new RoundRobinVolumeChoosingPolicy();

    AvailableSpaceVolumeChoosingPolicy(Random random) {
        this.random = random;
        this.initLocks();
    }

    public AvailableSpaceVolumeChoosingPolicy() {
        this(new Random());
    }

    private void initLocks() {
        int numStorageTypes = StorageType.values().length;
        this.syncLocks = new Object[numStorageTypes];
        for (int i = 0; i < numStorageTypes; ++i) {
            this.syncLocks[i] = new Object();
        }
    }

    public void setConf(Configuration conf) {
        this.balancedSpaceThreshold = conf.getLongBytes("dfs.datanode.available-space-volume-choosing-policy.balanced-space-threshold", 0x280000000L);
        this.balancedPreferencePercent = conf.getFloat("dfs.datanode.available-space-volume-choosing-policy.balanced-space-preference-fraction", 0.75f);
        LOG.info("Available space volume choosing policy initialized: dfs.datanode.available-space-volume-choosing-policy.balanced-space-threshold = " + this.balancedSpaceThreshold + ", " + "dfs.datanode.available-space-volume-choosing-policy.balanced-space-preference-fraction" + " = " + this.balancedPreferencePercent);
        if ((double)this.balancedPreferencePercent > 1.0) {
            LOG.warn("The value of dfs.datanode.available-space-volume-choosing-policy.balanced-space-preference-fraction is greater than 1.0 but should be in the range 0.0 - 1.0");
        }
        if ((double)this.balancedPreferencePercent < 0.5) {
            LOG.warn("The value of dfs.datanode.available-space-volume-choosing-policy.balanced-space-preference-fraction is less than 0.5 so volumes with less available disk space will receive more block allocations");
        }
    }

    public Configuration getConf() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V chooseVolume(List<V> volumes, long replicaSize, String storageId) throws IOException {
        if (volumes.size() < 1) {
            throw new DiskChecker.DiskOutOfSpaceException("No more available volumes");
        }
        StorageType storageType = ((FsVolumeSpi)volumes.get(0)).getStorageType();
        int index = storageType != null ? storageType.ordinal() : StorageType.DEFAULT.ordinal();
        Object object = this.syncLocks[index];
        synchronized (object) {
            return this.doChooseVolume(volumes, replicaSize, storageId);
        }
    }

    private V doChooseVolume(List<V> volumes, long replicaSize, String storageId) throws IOException {
        AvailableSpaceVolumeList volumesWithSpaces = new AvailableSpaceVolumeList(volumes);
        if (volumesWithSpaces.areAllVolumesWithinFreeSpaceThreshold()) {
            V volume = this.roundRobinPolicyBalanced.chooseVolume(volumes, replicaSize, storageId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("All volumes are within the configured free space balance threshold. Selecting " + volume + " for write of block size " + replicaSize);
            }
            return volume;
        }
        V volume = null;
        long mostAvailableAmongLowVolumes = volumesWithSpaces.getMostAvailableSpaceAmongVolumesWithLowAvailableSpace();
        List<V> highAvailableVolumes = this.extractVolumesFromPairs(volumesWithSpaces.getVolumesWithHighAvailableSpace());
        List<V> lowAvailableVolumes = this.extractVolumesFromPairs(volumesWithSpaces.getVolumesWithLowAvailableSpace());
        float preferencePercentScaler = (float)highAvailableVolumes.size() * this.balancedPreferencePercent + (float)lowAvailableVolumes.size() * (1.0f - this.balancedPreferencePercent);
        float scaledPreferencePercent = (float)highAvailableVolumes.size() * this.balancedPreferencePercent / preferencePercentScaler;
        if (mostAvailableAmongLowVolumes < replicaSize || this.random.nextFloat() < scaledPreferencePercent) {
            volume = this.roundRobinPolicyHighAvailable.chooseVolume(highAvailableVolumes, replicaSize, storageId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Volumes are imbalanced. Selecting " + volume + " from high available space volumes for write of block size " + replicaSize);
            }
        } else {
            volume = this.roundRobinPolicyLowAvailable.chooseVolume(lowAvailableVolumes, replicaSize, storageId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Volumes are imbalanced. Selecting " + volume + " from low available space volumes for write of block size " + replicaSize);
            }
        }
        return volume;
    }

    private List<V> extractVolumesFromPairs(List<AvailableSpaceVolumePair> volumes) {
        ArrayList ret = new ArrayList();
        for (AvailableSpaceVolumePair volume : volumes) {
            ret.add(volume.getVolume());
        }
        return ret;
    }

    private static class AvailableSpaceVolumePair {
        private final V volume;
        private final long availableSpace;
        final /* synthetic */ AvailableSpaceVolumeChoosingPolicy this$0;

        public AvailableSpaceVolumePair(V volume) throws IOException {
            this.this$0 = var1_1;
            this.volume = volume;
            this.availableSpace = volume.getAvailable();
        }

        public long getAvailable() {
            return this.availableSpace;
        }

        public V getVolume() {
            return this.volume;
        }
    }

    private class AvailableSpaceVolumeList {
        private final List<AvailableSpaceVolumePair> volumes = new ArrayList<AvailableSpaceVolumePair>();

        public AvailableSpaceVolumeList(List<V> volumes) throws IOException {
            for (FsVolumeSpi volume : volumes) {
                this.volumes.add(new AvailableSpaceVolumePair(AvailableSpaceVolumeChoosingPolicy.this, volume));
            }
        }

        public boolean areAllVolumesWithinFreeSpaceThreshold() {
            long leastAvailable = Long.MAX_VALUE;
            long mostAvailable = 0L;
            for (AvailableSpaceVolumePair volume : this.volumes) {
                leastAvailable = Math.min(leastAvailable, volume.getAvailable());
                mostAvailable = Math.max(mostAvailable, volume.getAvailable());
            }
            return mostAvailable - leastAvailable < AvailableSpaceVolumeChoosingPolicy.this.balancedSpaceThreshold;
        }

        private long getLeastAvailableSpace() {
            long leastAvailable = Long.MAX_VALUE;
            for (AvailableSpaceVolumePair volume : this.volumes) {
                leastAvailable = Math.min(leastAvailable, volume.getAvailable());
            }
            return leastAvailable;
        }

        public long getMostAvailableSpaceAmongVolumesWithLowAvailableSpace() {
            long mostAvailable = Long.MIN_VALUE;
            for (AvailableSpaceVolumePair volume : this.getVolumesWithLowAvailableSpace()) {
                mostAvailable = Math.max(mostAvailable, volume.getAvailable());
            }
            return mostAvailable;
        }

        public List<AvailableSpaceVolumePair> getVolumesWithLowAvailableSpace() {
            long leastAvailable = this.getLeastAvailableSpace();
            ArrayList<AvailableSpaceVolumePair> ret = new ArrayList<AvailableSpaceVolumePair>();
            for (AvailableSpaceVolumePair volume : this.volumes) {
                if (volume.getAvailable() > leastAvailable + AvailableSpaceVolumeChoosingPolicy.this.balancedSpaceThreshold) continue;
                ret.add(volume);
            }
            return ret;
        }

        public List<AvailableSpaceVolumePair> getVolumesWithHighAvailableSpace() {
            long leastAvailable = this.getLeastAvailableSpace();
            ArrayList<AvailableSpaceVolumePair> ret = new ArrayList<AvailableSpaceVolumePair>();
            for (AvailableSpaceVolumePair volume : this.volumes) {
                if (volume.getAvailable() <= leastAvailable + AvailableSpaceVolumeChoosingPolicy.this.balancedSpaceThreshold) continue;
                ret.add(volume);
            }
            return ret;
        }
    }
}

