/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.console;

import java.io.Serializable;
import java.util.Map;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.kendo.ui.console.ConsoleBehavior;
import org.wicketstuff.kendo.ui.console.ConsoleMessages;

public abstract class AbstractConsole
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    protected ConsoleBehavior consoleBehavior;

    public AbstractConsole(String id) {
        this(id, (IModel<ConsoleMessages>)Model.of((Serializable)new ConsoleMessages()));
    }

    public AbstractConsole(String id, int capacity) {
        this(id, (IModel<ConsoleMessages>)Model.of((Serializable)new ConsoleMessages(capacity)));
    }

    public AbstractConsole(String id, IModel<ConsoleMessages> model) {
        super(id, model);
        Args.notNull(model, (String)"model");
    }

    protected void onInitialize() {
        super.onInitialize();
        this.consoleBehavior = this.newConsoleBehavior();
        this.add(new Behavior[]{this.consoleBehavior});
    }

    public ConsoleMessages getModelObject() {
        return (ConsoleMessages)this.getDefaultModelObject();
    }

    public void log(Serializable message, boolean error) {
        this.getModelObject().put(message, error);
    }

    public void log(IPartialPageRequestHandler handler, Serializable message, boolean error) {
        this.log(message, error);
        handler.appendJavaScript((CharSequence)this.consoleBehavior.$(message, error));
    }

    protected String format(Serializable message, boolean error) {
        return String.valueOf(message).replace("'", "\\'");
    }

    public void clear() {
        this.getModelObject().clear();
    }

    protected ConsoleBehavior newConsoleBehavior() {
        return new ConsoleBehavior(){
            private static final long serialVersionUID = 1L;

            @Override
            protected String format(Serializable message, boolean error) {
                return AbstractConsole.this.format(message, error);
            }

            protected String $() {
                StringBuilder builder = new StringBuilder();
                for (Map.Entry entry : AbstractConsole.this.getModelObject().entrySet()) {
                    builder.append(this.$((Serializable)entry.getKey(), (Boolean)entry.getValue())).append("\n");
                }
                return builder.toString();
            }
        };
    }
}

