/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.scripting;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Set;
import java.util.regex.Matcher;
import lombok.Generated;
import org.apereo.cas.configuration.model.core.cache.ExpiringSimpleCacheProperties;
import org.apereo.cas.configuration.model.core.cache.SimpleCacheProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.concurrent.CasReentrantLock;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.scripting.ScriptResourceCacheManager;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class GroovyScriptResourceCacheManager
implements ScriptResourceCacheManager<String, ExecutableCompiledScript> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyScriptResourceCacheManager.class);
    private final CasReentrantLock lock = new CasReentrantLock();
    private final Cache<String, ExecutableCompiledScript> cache;

    public GroovyScriptResourceCacheManager(ExpiringSimpleCacheProperties properties) {
        this.cache = Beans.newCacheBuilder((SimpleCacheProperties)properties).build();
    }

    public ExecutableCompiledScript get(String key) {
        return (ExecutableCompiledScript)this.lock.tryLock(() -> (ExecutableCompiledScript)this.cache.getIfPresent((Object)key));
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    @CanIgnoreReturnValue
    public ScriptResourceCacheManager<String, ExecutableCompiledScript> put(String key, ExecutableCompiledScript value) {
        return (ScriptResourceCacheManager)this.lock.tryLock(() -> {
            this.cache.put((Object)key, (Object)value);
            return this;
        });
    }

    @CanIgnoreReturnValue
    public ScriptResourceCacheManager<String, ExecutableCompiledScript> remove(String key) {
        return (ScriptResourceCacheManager)this.lock.tryLock(() -> {
            this.cache.invalidate((Object)key);
            return this;
        });
    }

    public Set<String> getKeys() {
        return (Set)this.lock.tryLock(() -> this.cache.asMap().keySet());
    }

    public void close() {
        this.lock.tryLock(__ -> this.cache.invalidateAll());
    }

    public boolean isEmpty() {
        return (Boolean)this.lock.tryLock(() -> this.cache.asMap().isEmpty());
    }

    public ExecutableCompiledScript resolveScriptableResource(String scriptResource, String ... keys) {
        String cacheKey = this.computeKey(keys);
        LOGGER.trace("Constructed cache key [{}] for keys [{}] mapped as groovy script", (Object)cacheKey, (Object)keys);
        ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
        ExecutableCompiledScript script = null;
        if (this.containsKey(cacheKey)) {
            script = this.get(cacheKey);
            LOGGER.trace("Located cached groovy script [{}] for key [{}]", (Object)script, (Object)cacheKey);
        } else {
            try {
                if (ScriptingUtils.isExternalGroovyScript(scriptResource)) {
                    String scriptPath = SpringExpressionLanguageValueResolver.getInstance().resolve(scriptResource);
                    AbstractResource resource = ResourceUtils.getResourceFrom((String)scriptPath);
                    script = scriptFactory.fromResource((Resource)resource);
                } else {
                    Matcher matcher;
                    String resourceToUse = scriptResource;
                    if (ScriptingUtils.isInlineGroovyScript(resourceToUse) && (matcher = ScriptingUtils.getMatcherForInlineGroovyScript(resourceToUse)).find()) {
                        resourceToUse = matcher.group(1);
                    }
                    script = scriptFactory.fromScript(resourceToUse);
                }
                LOGGER.trace("Groovy script [{}] for key [{}] is not cached", (Object)scriptResource, (Object)cacheKey);
                this.put(cacheKey, script);
                LOGGER.trace("Cached groovy script [{}] for key [{}]", (Object)script, (Object)cacheKey);
            }
            catch (Exception e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            }
        }
        return script;
    }

    public String computeKey(String ... keys) {
        String rawKey = String.join((CharSequence)":", keys);
        return DigestUtils.sha256((String)rawKey);
    }
}

