/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.jodatime;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import de.javakaffee.kryoserializers.jodatime.IdentifiableChronology;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalTime;

public class JodaLocalTimeSerializer
extends Serializer<LocalTime> {
    public void write(Kryo kryo, Output output, LocalTime object) {
        int time = object.getMillisOfDay();
        output.writeInt(time, true);
        String chronologyId = IdentifiableChronology.getChronologyId(object.getChronology());
        output.writeString(chronologyId);
    }

    public LocalTime read(Kryo kryo, Input input, Class<? extends LocalTime> type) {
        int time = input.readInt(true);
        Chronology chronology = IdentifiableChronology.readChronology(input);
        return new LocalTime((long)time, chronology.withZone(DateTimeZone.UTC));
    }

    public LocalTime copy(Kryo kryo, LocalTime original) {
        return new LocalTime((Object)original);
    }
}

