/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.test;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import org.flowable.common.engine.api.Engine;
import org.flowable.common.engine.api.engine.EngineLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosingDataSource
implements DataSource,
EngineLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClosingDataSource.class);
    protected DataSource dataSource;

    public ClosingDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void onEngineBuilt(Engine engine) {
    }

    public void onEngineClosed(Engine engine) {
        if (this.dataSource instanceof Closeable) {
            try {
                LOGGER.info("About to close dataSource");
                ((Closeable)((Object)this.dataSource)).close();
                LOGGER.info("DataSource closed");
            }
            catch (IOException e) {
                LOGGER.warn("Exception while closing dataSource", (Throwable)e);
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.dataSource.getConnection(username, password);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }
}

