/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.common.web;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.inspektr.common.web.ClientInfoExtractionOptions;
import org.jooq.lambda.Unchecked;

public class ClientInfo
implements Serializable {
    private static final long serialVersionUID = 7492721606084356617L;
    private static final String UNKNOWN = "unknown";
    @JsonProperty(value="clientIpAddress")
    private String clientIpAddress;
    @JsonProperty(value="serverIpAddress")
    private String serverIpAddress;
    @JsonProperty(value="geoLocation")
    private String geoLocation;
    @JsonProperty(value="userAgent")
    private String userAgent;
    @JsonProperty(value="deviceFingerprint")
    private String deviceFingerprint;
    @JsonProperty(value="headers")
    private Map<String, String> headers = new HashMap<String, String>();
    @JsonProperty(value="extraInfo")
    private Map<String, Serializable> extraInfo = new HashMap<String, Serializable>();
    @JsonProperty(value="locale")
    private Locale locale;
    @JsonProperty(value="tenant")
    private String tenant;

    public ClientInfo(String clientIpAddress, String serverIpAddress, String userAgent, String geoLocation) {
        this.setClientIpAddress(clientIpAddress);
        this.setServerIpAddress(serverIpAddress);
        this.setUserAgent(userAgent);
        this.setGeoLocation(geoLocation);
    }

    public String getDeviceFingerprint() {
        return Objects.requireNonNullElse(this.deviceFingerprint, UNKNOWN);
    }

    public String getServerIpAddress() {
        return Objects.requireNonNullElse(this.serverIpAddress, UNKNOWN);
    }

    public String getClientIpAddress() {
        return Objects.requireNonNullElse(this.clientIpAddress, UNKNOWN);
    }

    public String getGeoLocation() {
        return Objects.requireNonNullElse(this.geoLocation, UNKNOWN);
    }

    public String getUserAgent() {
        return Objects.requireNonNullElse(this.userAgent, UNKNOWN);
    }

    public Map<String, Serializable> getHeaders() {
        return Map.copyOf(this.headers);
    }

    public Locale getLocale() {
        return Objects.requireNonNullElse(this.locale, Locale.ENGLISH);
    }

    @CanIgnoreReturnValue
    public ClientInfo setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    @CanIgnoreReturnValue
    public ClientInfo setServerIpAddress(String serverIpAddress) {
        this.serverIpAddress = serverIpAddress;
        return this;
    }

    @CanIgnoreReturnValue
    public ClientInfo setClientIpAddress(String clientIpAddress) {
        this.clientIpAddress = clientIpAddress;
        return this;
    }

    @CanIgnoreReturnValue
    public ClientInfo setGeoLocation(String geoLocation) {
        this.geoLocation = geoLocation;
        return this;
    }

    @CanIgnoreReturnValue
    public ClientInfo setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @CanIgnoreReturnValue
    public ClientInfo setTenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    @CanIgnoreReturnValue
    public ClientInfo setDeviceFingerprint(String value) {
        this.deviceFingerprint = value;
        return this;
    }

    @CanIgnoreReturnValue
    public ClientInfo setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public Map<String, ? extends Serializable> getExtraInfo() {
        return Map.copyOf(this.extraInfo);
    }

    @CanIgnoreReturnValue
    public ClientInfo setExtraInfo(Map<String, Serializable> extraInfo) {
        this.extraInfo = extraInfo;
        return this;
    }

    public static ClientInfo empty() {
        return new ClientInfo();
    }

    @CanIgnoreReturnValue
    public ClientInfo include(String name, Serializable value) {
        this.extraInfo.put(name, value);
        return this;
    }

    public static ClientInfo from(HttpServletRequest request) {
        return ClientInfo.from(request, ClientInfoExtractionOptions.builder().build());
    }

    public static ClientInfo from(HttpServletRequest request, ClientInfoExtractionOptions options) {
        Locale locale = request != null ? request.getLocale() : Locale.getDefault();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (request != null) {
            List<String> definedHeaders = options.getHttpRequestHeaders();
            Collections.list(request.getHeaderNames()).stream().filter(headerName -> definedHeaders.contains("*") || definedHeaders.contains(headerName)).forEach(headerName -> headers.put((String)headerName, request.getHeader(headerName)));
        }
        String serverIpAddress = request != null ? request.getLocalAddr() : null;
        String clientIpAddress = request != null ? request.getRemoteAddr() : null;
        String geoLocation = UNKNOWN;
        String userAgent = UNKNOWN;
        String deviceFingerprint = UNKNOWN;
        String tenantId = "";
        if (request != null) {
            String header;
            if (options.isUseServerHostAddress()) {
                serverIpAddress = (String)Unchecked.supplier(() -> InetAddress.getLocalHost().getHostAddress()).get();
            } else if (options.getAlternateServerAddrHeaderName() != null && !options.getAlternateServerAddrHeaderName().isEmpty()) {
                String string = serverIpAddress = request.getHeader(options.getAlternateServerAddrHeaderName()) != null ? request.getHeader(options.getAlternateServerAddrHeaderName()) : request.getLocalAddr();
            }
            if (options.getAlternateLocalAddrHeaderName() != null && !options.getAlternateLocalAddrHeaderName().isEmpty()) {
                clientIpAddress = request.getHeader(options.getAlternateLocalAddrHeaderName()) != null ? request.getHeader(options.getAlternateLocalAddrHeaderName()) : request.getRemoteAddr();
            }
            userAgent = (header = request.getHeader("User-Agent")) == null ? UNKNOWN : header;
            String geo = request.getParameter("geolocation");
            if (geo == null) {
                geo = request.getHeader("geolocation");
            }
            geoLocation = geo == null ? UNKNOWN : geo;
            deviceFingerprint = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("deviceFingerprint"), (CharSequence)UNKNOWN);
            tenantId = TenantExtractor.tenantIdFromPath((String)request.getContextPath());
        }
        String serverIp = serverIpAddress == null ? UNKNOWN : serverIpAddress;
        String clientIp = clientIpAddress == null ? UNKNOWN : clientIpAddress;
        return ClientInfo.empty().setClientIpAddress(clientIp).setServerIpAddress(serverIp).setLocale(locale).setGeoLocation(StringEscapeUtils.escapeHtml4((String)geoLocation)).setUserAgent(StringEscapeUtils.escapeHtml4((String)userAgent)).setDeviceFingerprint(deviceFingerprint).setTenant(tenantId).setHeaders(headers);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientInfo)) {
            return false;
        }
        ClientInfo other = (ClientInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientIpAddress = this.clientIpAddress;
        String other$clientIpAddress = other.clientIpAddress;
        if (this$clientIpAddress == null ? other$clientIpAddress != null : !this$clientIpAddress.equals(other$clientIpAddress)) {
            return false;
        }
        String this$serverIpAddress = this.serverIpAddress;
        String other$serverIpAddress = other.serverIpAddress;
        if (this$serverIpAddress == null ? other$serverIpAddress != null : !this$serverIpAddress.equals(other$serverIpAddress)) {
            return false;
        }
        String this$geoLocation = this.geoLocation;
        String other$geoLocation = other.geoLocation;
        if (this$geoLocation == null ? other$geoLocation != null : !this$geoLocation.equals(other$geoLocation)) {
            return false;
        }
        String this$userAgent = this.userAgent;
        String other$userAgent = other.userAgent;
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        String this$deviceFingerprint = this.deviceFingerprint;
        String other$deviceFingerprint = other.deviceFingerprint;
        if (this$deviceFingerprint == null ? other$deviceFingerprint != null : !this$deviceFingerprint.equals(other$deviceFingerprint)) {
            return false;
        }
        Map<String, String> this$headers = this.headers;
        Map<String, String> other$headers = other.headers;
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, Serializable> this$extraInfo = this.extraInfo;
        Map<String, Serializable> other$extraInfo = other.extraInfo;
        if (this$extraInfo == null ? other$extraInfo != null : !((Object)this$extraInfo).equals(other$extraInfo)) {
            return false;
        }
        Locale this$locale = this.locale;
        Locale other$locale = other.locale;
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        String this$tenant = this.tenant;
        String other$tenant = other.tenant;
        return !(this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientIpAddress = this.clientIpAddress;
        result = result * 59 + ($clientIpAddress == null ? 43 : $clientIpAddress.hashCode());
        String $serverIpAddress = this.serverIpAddress;
        result = result * 59 + ($serverIpAddress == null ? 43 : $serverIpAddress.hashCode());
        String $geoLocation = this.geoLocation;
        result = result * 59 + ($geoLocation == null ? 43 : $geoLocation.hashCode());
        String $userAgent = this.userAgent;
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        String $deviceFingerprint = this.deviceFingerprint;
        result = result * 59 + ($deviceFingerprint == null ? 43 : $deviceFingerprint.hashCode());
        Map<String, String> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, Serializable> $extraInfo = this.extraInfo;
        result = result * 59 + ($extraInfo == null ? 43 : ((Object)$extraInfo).hashCode());
        Locale $locale = this.locale;
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        String $tenant = this.tenant;
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        return result;
    }

    @Generated
    public ClientInfo() {
    }

    @Generated
    public ClientInfo(String clientIpAddress, String serverIpAddress, String geoLocation, String userAgent, String deviceFingerprint, Map<String, String> headers, Map<String, Serializable> extraInfo, Locale locale, String tenant) {
        this.clientIpAddress = clientIpAddress;
        this.serverIpAddress = serverIpAddress;
        this.geoLocation = geoLocation;
        this.userAgent = userAgent;
        this.deviceFingerprint = deviceFingerprint;
        this.headers = headers;
        this.extraInfo = extraInfo;
        this.locale = locale;
        this.tenant = tenant;
    }

    @Generated
    public String getTenant() {
        return this.tenant;
    }
}

