/*
 * Decompiled with CFR 0.152.
 */
package org.hjson;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.hjson.HjsonOptions;
import org.hjson.HjsonParser;
import org.hjson.HjsonWriter;
import org.hjson.JsonArray;
import org.hjson.JsonDsf;
import org.hjson.JsonLiteral;
import org.hjson.JsonNumber;
import org.hjson.JsonObject;
import org.hjson.JsonParser;
import org.hjson.JsonString;
import org.hjson.JsonType;
import org.hjson.JsonWriter;
import org.hjson.Stringify;
import org.hjson.WritingBuffer;

public abstract class JsonValue
implements Serializable {
    public static final JsonValue TRUE = JsonLiteral.TRUE;
    public static final JsonValue FALSE = JsonLiteral.FALSE;
    public static final JsonValue NULL = JsonLiteral.NULL;
    static String eol = System.getProperty("line.separator");

    public static String getEol() {
        return eol;
    }

    public static void setEol(String value) {
        if (value.equals("\r\n") || value.equals("\n")) {
            eol = value;
        }
    }

    JsonValue() {
    }

    public static JsonValue readHjson(Reader reader) throws IOException {
        return new HjsonParser(reader, null).parse();
    }

    public static JsonValue readHjson(String text) {
        try {
            return new HjsonParser(text, null).parse();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static JsonValue readHjson(Reader reader, HjsonOptions options) throws IOException {
        return new HjsonParser(reader, options).parse();
    }

    public static JsonValue readHjson(String text, HjsonOptions options) {
        try {
            return new HjsonParser(text, options).parse();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static JsonValue readJSON(Reader reader) throws IOException {
        return new JsonParser(reader).parse();
    }

    public static JsonValue readJSON(String text) {
        try {
            return new JsonParser(text).parse();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static JsonValue valueOf(int value) {
        return new JsonNumber(value);
    }

    public static JsonValue valueOf(long value) {
        return new JsonNumber(value);
    }

    public static JsonValue valueOf(float value) {
        return new JsonNumber(value);
    }

    public static JsonValue valueOf(double value) {
        return new JsonNumber(value);
    }

    public static JsonValue valueOf(String string) {
        return string == null ? NULL : new JsonString(string);
    }

    public static JsonValue valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static JsonValue valueOfDsf(Object value) {
        return new JsonDsf(value);
    }

    public abstract JsonType getType();

    public boolean isObject() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public JsonObject asObject() {
        throw new UnsupportedOperationException("Not an object: " + this.toString());
    }

    public JsonArray asArray() {
        throw new UnsupportedOperationException("Not an array: " + this.toString());
    }

    public int asInt() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public long asLong() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public float asFloat() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public double asDouble() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public String asString() {
        throw new UnsupportedOperationException("Not a string: " + this.toString());
    }

    public boolean asBoolean() {
        throw new UnsupportedOperationException("Not a boolean: " + this.toString());
    }

    public Object asDsf() {
        throw new UnsupportedOperationException("Not a DSF");
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeTo(writer, Stringify.PLAIN);
    }

    public void writeTo(Writer writer, Stringify format) throws IOException {
        WritingBuffer buffer = new WritingBuffer(writer, 128);
        switch (format) {
            case PLAIN: {
                new JsonWriter(false).save(this, buffer, 0);
                break;
            }
            case FORMATTED: {
                new JsonWriter(true).save(this, buffer, 0);
                break;
            }
            case HJSON: {
                new HjsonWriter(null).save(this, buffer, 0, "", true);
            }
        }
        buffer.flush();
    }

    public void writeTo(Writer writer, HjsonOptions options) throws IOException {
        if (options == null) {
            throw new NullPointerException("options is null");
        }
        WritingBuffer buffer = new WritingBuffer(writer, 128);
        new HjsonWriter(options).save(this, buffer, 0, "", true);
        buffer.flush();
    }

    public String toString() {
        return this.toString(Stringify.PLAIN);
    }

    public String toString(Stringify format) {
        StringWriter writer = new StringWriter();
        try {
            this.writeTo((Writer)writer, format);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return writer.toString();
    }

    public String toString(HjsonOptions options) {
        StringWriter writer = new StringWriter();
        try {
            this.writeTo((Writer)writer, options);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return writer.toString();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    static boolean isPunctuatorChar(int c) {
        return c == 123 || c == 125 || c == 91 || c == 93 || c == 44 || c == 58;
    }
}

