/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.csp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.wicket.csp.CSPDirective;
import org.apache.wicket.csp.CSPDirectiveSrcValue;
import org.apache.wicket.csp.CSPRenderable;
import org.apache.wicket.csp.ClonedCSPValue;
import org.apache.wicket.csp.ContentSecurityPolicySettings;
import org.apache.wicket.csp.FixedCSPValue;
import org.apache.wicket.csp.RelativeURICSPValue;
import org.apache.wicket.request.cycle.RequestCycle;

public class CSPHeaderConfiguration {
    public static final String CSP_VIOLATION_REPORTING_URI = "cspviolation";
    private final Map<CSPDirective, List<CSPRenderable>> directives = new EnumMap<CSPDirective, List<CSPRenderable>>(CSPDirective.class);
    private boolean addLegacyHeaders = false;
    private boolean nonceEnabled = false;
    private String reportUriMountPath = null;

    public CSPHeaderConfiguration disabled() {
        return this.clear();
    }

    public CSPHeaderConfiguration unsafeInline() {
        return this.clear().add(CSPDirective.DEFAULT_SRC, CSPDirectiveSrcValue.NONE).add(CSPDirective.SCRIPT_SRC, CSPDirectiveSrcValue.SELF, CSPDirectiveSrcValue.UNSAFE_INLINE, CSPDirectiveSrcValue.UNSAFE_EVAL).add(CSPDirective.STYLE_SRC, CSPDirectiveSrcValue.SELF, CSPDirectiveSrcValue.UNSAFE_INLINE).add(CSPDirective.IMG_SRC, CSPDirectiveSrcValue.SELF).add(CSPDirective.CONNECT_SRC, CSPDirectiveSrcValue.SELF).add(CSPDirective.FONT_SRC, CSPDirectiveSrcValue.SELF).add(CSPDirective.MANIFEST_SRC, CSPDirectiveSrcValue.SELF).add(CSPDirective.CHILD_SRC, CSPDirectiveSrcValue.SELF).add(CSPDirective.BASE_URI, CSPDirectiveSrcValue.SELF);
    }

    public CSPHeaderConfiguration strict() {
        return this.clear().add(CSPDirective.DEFAULT_SRC, CSPDirectiveSrcValue.NONE).add(CSPDirective.SCRIPT_SRC, CSPDirectiveSrcValue.STRICT_DYNAMIC, CSPDirectiveSrcValue.NONCE).add(CSPDirective.STYLE_SRC, CSPDirectiveSrcValue.NONCE).add(CSPDirective.IMG_SRC, CSPDirectiveSrcValue.SELF).add(CSPDirective.CONNECT_SRC, CSPDirectiveSrcValue.SELF).add(CSPDirective.FONT_SRC, CSPDirectiveSrcValue.SELF).add(CSPDirective.MANIFEST_SRC, CSPDirectiveSrcValue.SELF).add(CSPDirective.CHILD_SRC, CSPDirectiveSrcValue.SELF).add(CSPDirective.BASE_URI, CSPDirectiveSrcValue.SELF);
    }

    public CSPHeaderConfiguration reportBack() {
        return this.reportBackAt(CSP_VIOLATION_REPORTING_URI);
    }

    public CSPHeaderConfiguration reportBackAt(String mountPath) {
        return this.add(CSPDirective.REPORT_URI, new RelativeURICSPValue(mountPath));
    }

    String getReportUriMountPath() {
        return this.reportUriMountPath;
    }

    public boolean isNonceEnabled() {
        return this.nonceEnabled;
    }

    public boolean isAddLegacyHeaders() {
        return this.addLegacyHeaders;
    }

    public CSPHeaderConfiguration setAddLegacyHeaders(boolean addLegacyHeaders) {
        this.addLegacyHeaders = addLegacyHeaders;
        return this;
    }

    public CSPHeaderConfiguration remove(CSPDirective directive) {
        this.directives.remove((Object)directive);
        return this.recalculateState();
    }

    public CSPHeaderConfiguration add(CSPDirective directive, CSPRenderable ... values) {
        for (CSPRenderable value : values) {
            this.doAddDirective(directive, value);
        }
        return this.recalculateState();
    }

    public CSPHeaderConfiguration add(CSPDirective directive, String ... values) {
        for (String value : values) {
            this.doAddDirective(directive, new FixedCSPValue(value));
        }
        return this.recalculateState();
    }

    public Map<CSPDirective, List<CSPRenderable>> getDirectives() {
        return Collections.unmodifiableMap(this.directives);
    }

    public boolean isSet() {
        return !this.directives.isEmpty();
    }

    public CSPHeaderConfiguration clear() {
        this.directives.clear();
        return this.recalculateState();
    }

    private CSPHeaderConfiguration recalculateState() {
        CSPRenderable reportUri;
        this.nonceEnabled = this.directives.values().stream().flatMap(Collection::stream).anyMatch(value -> value == CSPDirectiveSrcValue.NONCE);
        this.reportUriMountPath = null;
        List<CSPRenderable> reportValues = this.directives.get((Object)CSPDirective.REPORT_URI);
        if (reportValues != null && !reportValues.isEmpty() && (reportUri = reportValues.get(0)) instanceof RelativeURICSPValue) {
            this.reportUriMountPath = reportUri.toString();
        }
        return this;
    }

    private void doAddDirective(CSPDirective directive, CSPRenderable value) {
        if (CSPDirective.CHILD_SRC.equals((Object)directive) && !this.directives.containsKey((Object)CSPDirective.FRAME_SRC)) {
            this.doAddDirective(CSPDirective.FRAME_SRC, new ClonedCSPValue(this, CSPDirective.CHILD_SRC));
        }
        List values = this.directives.computeIfAbsent(directive, x -> new ArrayList());
        directive.checkValueForDirective(value, values);
        values.add(value);
    }

    public String renderHeaderValue(ContentSecurityPolicySettings settings, RequestCycle cycle) {
        return this.directives.entrySet().stream().map(e -> ((CSPDirective)((Object)((Object)e.getKey()))).getValue() + " " + ((List)e.getValue()).stream().map(r -> r.render(settings, cycle)).collect(Collectors.joining(" "))).collect(Collectors.joining("; "));
    }
}

