/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.StandardOpenOption;
import kafka.utils.Logging;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000553A!\u0004\b\u0001'!Aa\u0004\u0001BC\u0002\u0013\u0005q\u0004\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003!\u0011\u0015I\u0003\u0001\"\u0001+\u0011\u001di\u0003A1A\u0005\n9Baa\u000e\u0001!\u0002\u0013y\u0003\"\u0003\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0003:\u0011%a\u0004\u00011AA\u0002\u0013%Q\bC\u0005D\u0001\u0001\u0007\t\u0011)Q\u0005u!)A\t\u0001C\u0001\u000b\")a\t\u0001C\u0001\u000f\")1\n\u0001C\u0001\u000b\")A\n\u0001C\u0001\u000b\nAa)\u001b7f\u0019>\u001c7N\u0003\u0002\u0010!\u0005)Q\u000f^5mg*\t\u0011#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001!\"\u0004\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\t\u00037qi\u0011AD\u0005\u0003;9\u0011q\u0001T8hO&tw-\u0001\u0003gS2,W#\u0001\u0011\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013AA5p\u0015\u0005)\u0013\u0001\u00026bm\u0006L!a\n\u0012\u0003\t\u0019KG.Z\u0001\u0006M&dW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005-b\u0003CA\u000e\u0001\u0011\u0015q2\u00011\u0001!\u0003\u001d\u0019\u0007.\u00198oK2,\u0012a\f\t\u0003aUj\u0011!\r\u0006\u0003eM\n\u0001b\u00195b]:,Gn\u001d\u0006\u0003i\u0011\n1A\\5p\u0013\t1\u0014GA\u0006GS2,7\t[1o]\u0016d\u0017\u0001C2iC:tW\r\u001c\u0011\u0002\u000b\u0019dwnY6\u0016\u0003i\u0002\"\u0001M\u001e\n\u00055\t\u0014!\u00034m_\u000e\\w\fJ3r)\tq\u0014\t\u0005\u0002\u0016\u007f%\u0011\u0001I\u0006\u0002\u0005+:LG\u000fC\u0004C\u000f\u0005\u0005\t\u0019\u0001\u001e\u0002\u0007a$\u0013'\u0001\u0004gY>\u001c7\u000eI\u0001\u0005Y>\u001c7\u000eF\u0001?\u0003\u001d!(/\u001f'pG.$\u0012\u0001\u0013\t\u0003+%K!A\u0013\f\u0003\u000f\t{w\u000e\\3b]\u00061QO\u001c7pG.\fq\u0001Z3tiJ|\u0017\u0010")
public class FileLock
implements Logging {
    private final File file;
    private final FileChannel channel;
    private java.nio.channels.FileLock flock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    private FileChannel channel() {
        return this.channel;
    }

    private java.nio.channels.FileLock flock() {
        return this.flock;
    }

    private void flock_$eq(java.nio.channels.FileLock x$1) {
        this.flock = x$1;
    }

    public synchronized void lock() {
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("Acquiring lock on ").append(this.file().getAbsolutePath()).toString());
        this.flock_$eq(this.channel().lock());
    }

    public synchronized boolean tryLock() {
        boolean bl;
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("Acquiring lock on ").append(this.file().getAbsolutePath()).toString());
        try {
            this.flock_$eq(this.channel().tryLock());
            if (this.flock() == null) {
                return false;
            }
            bl = true;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            bl = false;
        }
        return bl;
    }

    public synchronized void unlock() {
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("Releasing lock on ").append(this.file().getAbsolutePath()).toString());
        if (this.flock() != null) {
            this.flock().release();
            return;
        }
    }

    public synchronized void destroy() {
        this.unlock();
        if (this.file().exists() && this.file().delete()) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(7).append("Delete ").append(this.file().getAbsolutePath()).toString());
        }
        this.channel().close();
    }

    public FileLock(File file) {
        this.file = file;
        this.channel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
    }
}

