/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds;

import com.okta.commons.lang.Classes;
import com.okta.sdk.impl.ds.DiscriminatorConfig;
import com.okta.sdk.impl.ds.DiscriminatorRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultDiscriminatorRegistry
implements DiscriminatorRegistry {
    private final Map<Class, AttributeDiscriminationStrategy> supportedClassMap = new HashMap<Class, AttributeDiscriminationStrategy>();

    public DefaultDiscriminatorRegistry() {
        DiscriminatorConfig.loadConfig().getConfig().forEach((key, value) -> {
            Class clazz = Classes.forName((String)key);
            Map<String, Class> values = value.getValues().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Classes.forName((String)((String)e.getValue()))));
            this.supportedClassMap.put(clazz, new AttributeDiscriminationStrategy(value.getFieldName(), values));
        });
    }

    @Override
    public boolean supportedClass(Class clazz) {
        return this.supportedClassMap.containsKey(clazz);
    }

    @Override
    public <P> Class<P> resolve(Class<P> clazz, Map data) {
        if (this.supportedClass(clazz)) {
            Class result = this.supportedClassMap.get(clazz).resolve(clazz, data);
            if (clazz != result) {
                return this.resolve(result, data);
            }
            return result;
        }
        return clazz;
    }

    private static class AttributeDiscriminationStrategy {
        private final String key;
        private final Map<String, Class> values;

        private AttributeDiscriminationStrategy(String key, Map<String, Class> values) {
            this.key = key;
            this.values = values;
        }

        private <P> Class<P> resolve(Class<P> clazz, Map data) {
            Object value;
            Class result;
            if (data.containsKey(this.key) && (result = this.values.get(value = data.get(this.key))) != null) {
                return result;
            }
            return clazz;
        }
    }
}

