/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.util;

import de.agilecoders.wicket.webjars.util.ClasspathUrlStreamHandler;
import de.agilecoders.wicket.webjars.util.IResourceStreamProvider;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.wicket.core.util.resource.UrlResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlResourceStreamProvider
implements IResourceStreamProvider {
    private static final Logger LOG = LoggerFactory.getLogger((String)"wicket-webjars");
    private final ClasspathUrlStreamHandler urlHandler;

    public UrlResourceStreamProvider(ClassLoader ... classLoaders) {
        this.urlHandler = new ClasspathUrlStreamHandler(classLoaders);
    }

    @Override
    public IResourceStream newResourceStream(String path) {
        try {
            return new UrlResourceStream(new URL(null, "classpath:" + path, this.urlHandler));
        }
        catch (MalformedURLException e) {
            LOG.warn("can't create URL to resource: {}", (Object)e.getMessage());
            return null;
        }
    }
}

