/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.Assert;

abstract class AbstractClientHttpRequestFactoryBuilder<T extends ClientHttpRequestFactory>
implements ClientHttpRequestFactoryBuilder<T> {
    private static final Consumer<?> EMPTY_CUSTOMIZER = t -> {};
    private final List<Consumer<T>> customizers;

    protected AbstractClientHttpRequestFactoryBuilder(List<Consumer<T>> customizers) {
        this.customizers = customizers != null ? customizers : Collections.emptyList();
    }

    protected static <T> Consumer<T> emptyCustomizer() {
        return EMPTY_CUSTOMIZER;
    }

    protected final List<Consumer<T>> getCustomizers() {
        return this.customizers;
    }

    protected final List<Consumer<T>> mergedCustomizers(Consumer<T> customizer) {
        Assert.notNull(this.customizers, (String)"'customizer' must not be null");
        return this.merge(this.customizers, List.of(customizer));
    }

    protected final List<Consumer<T>> mergedCustomizers(Collection<Consumer<T>> customizers) {
        Assert.notNull(customizers, (String)"'customizers' must not be null");
        Assert.noNullElements(customizers, (String)"'customizers' must not contain null elements");
        return this.merge(this.customizers, customizers);
    }

    private <E> List<E> merge(Collection<E> list, Collection<? extends E> additional) {
        ArrayList<? extends E> merged = new ArrayList<E>(list);
        merged.addAll(additional);
        return List.copyOf(merged);
    }

    @Override
    public final T build(ClientHttpRequestFactorySettings settings) {
        Object factory = this.createClientHttpRequestFactory(settings != null ? settings : ClientHttpRequestFactorySettings.defaults());
        LambdaSafe.callbacks(Consumer.class, this.customizers, factory, new Object[0]).invoke(consumer -> consumer.accept(factory));
        return factory;
    }

    protected abstract T createClientHttpRequestFactory(ClientHttpRequestFactorySettings var1);
}

