/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.external.beanvalidation;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.external.beanvalidation.BeanValidationProperties;
import org.apache.wicket.Application;
import org.apache.wicket.bean.validation.BeanValidationConfiguration;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@ApplicationInitExtension
@Component
@ConditionalOnProperty(prefix="wicket.external.beanvalidation", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={BeanValidationConfiguration.class})
@EnableConfigurationProperties(value={BeanValidationProperties.class})
public class BeanValidationConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private BeanValidationProperties props;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        new BeanValidationConfiguration().configure((Application)webApplication);
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.props).build());
    }
}

