/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.TraceLevel;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ResourceDetailsPanel
extends WizardStep {
    private static final long serialVersionUID = -7982691107029848579L;
    @SpringBean
    protected ImplementationRestClient implementationRestClient;
    @SpringBean
    protected ConnectorRestClient connectorRestClient;
    protected AjaxDropDownChoicePanel<String> connector;
    protected final IModel<List<String>> propagationActions = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return ResourceDetailsPanel.this.implementationRestClient.list("PROPAGATION_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
        }
    };
    protected final IModel<List<String>> provisionSorters = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 4659376149825914247L;

        protected List<String> load() {
            return ResourceDetailsPanel.this.implementationRestClient.list("PROVISION_SORTER").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
        }
    };

    public ResourceDetailsPanel(ResourceTO resourceTO, boolean createFlag) {
        this.setOutputMarkupId(true);
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        container.setRenderBodyOnly(true);
        this.add(new Component[]{container});
        container.add(new Component[]{new AjaxTextFieldPanel("key", new ResourceModel("key", "key").getObject(), (IModel)new PropertyModel((Object)resourceTO, "key"), false).addRequiredLabel().setEnabled(createFlag)});
        container.add(new Component[]{new AjaxCheckBoxPanel("enforceMandatoryCondition", new ResourceModel("enforceMandatoryCondition", "enforceMandatoryCondition").getObject(), (IModel)new PropertyModel((Object)resourceTO, "enforceMandatoryCondition"), false)});
        container.add(new Component[]{new AjaxNumberFieldPanel.Builder().build("propagationPriority", "propagationPriority", Integer.class, (IModel)new PropertyModel((Object)resourceTO, "propagationPriority"))});
        container.add(new Component[]{new AjaxPalettePanel.Builder().setAllowMoveAll(true).setAllowOrder(true).build("propagationActions", (IModel)new PropertyModel((Object)resourceTO, "propagationActions"), (IModel)new ListModel((List)this.propagationActions.getObject())).setOutputMarkupId(true)});
        container.add(new Component[]{new AjaxDropDownChoicePanel("createTraceLevel", new ResourceModel("createTraceLevel", "createTraceLevel").getObject(), (IModel)new PropertyModel((Object)resourceTO, "createTraceLevel"), false).setChoices(Arrays.stream(TraceLevel.values()).collect(Collectors.toList())).setNullValid(false)});
        container.add(new Component[]{new AjaxDropDownChoicePanel("provisionSorter", "provisionSorter", (IModel)new PropertyModel((Object)resourceTO, "provisionSorter"), false).setChoices(this.provisionSorters)});
        container.add(new Component[]{new AjaxDropDownChoicePanel("updateTraceLevel", new ResourceModel("updateTraceLevel", "updateTraceLevel").getObject(), (IModel)new PropertyModel((Object)resourceTO, "updateTraceLevel"), false).setChoices(Arrays.stream(TraceLevel.values()).collect(Collectors.toList())).setNullValid(false)});
        container.add(new Component[]{new AjaxDropDownChoicePanel("deleteTraceLevel", new ResourceModel("deleteTraceLevel", "deleteTraceLevel").getObject(), (IModel)new PropertyModel((Object)resourceTO, "deleteTraceLevel"), false).setChoices(Arrays.stream(TraceLevel.values()).collect(Collectors.toList())).setNullValid(false)});
        container.add(new Component[]{new AjaxDropDownChoicePanel("provisioningTraceLevel", new ResourceModel("provisioningTraceLevel", "provisioningTraceLevel").getObject(), (IModel)new PropertyModel((Object)resourceTO, "provisioningTraceLevel"), false).setChoices(Arrays.stream(TraceLevel.values()).collect(Collectors.toList())).setNullValid(false)});
        if (resourceTO.getConnector() != null) {
            container.add(new Component[]{new AjaxTextFieldPanel("connector", new ResourceModel("connector", "connector").getObject(), (IModel)new Model((Serializable)((Object)resourceTO.getConnectorDisplayName())), false).addRequiredLabel().setEnabled(false)});
        } else {
            this.connector = new AjaxDropDownChoicePanel("connector", new ResourceModel("connector", "connector").getObject(), (IModel)new PropertyModel((Object)resourceTO, "connector"), false);
            final Map<String, String> connectorsMap = this.connectorRestClient.getAllConnectors().stream().collect(Collectors.toMap(ConnInstanceTO::getKey, ConnInstanceTO::getDisplayName));
            this.connector.setChoices(connectorsMap.keySet().stream().sorted().collect(Collectors.toList()));
            this.connector.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<String>(){
                private static final long serialVersionUID = 91313845533448846L;
                private final Map<String, String> valueMap;
                {
                    this.valueMap = connectorsMap;
                }

                public String getDisplayValue(String value) {
                    return Optional.ofNullable(this.valueMap.get(value)).orElse(null);
                }

                public String getIdValue(String value, int i) {
                    return value;
                }

                public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                    return id;
                }
            });
            this.connector.addRequiredLabel();
            this.connector.setOutputMarkupId(true);
            this.connector.getField().setOutputMarkupId(true);
            container.add(new Component[]{this.connector});
        }
    }

    public AjaxDropDownChoicePanel<String> getConnector() {
        return this.connector;
    }
}

