/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.AnonymousProfile;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenDeviceCodeResponseRequestExtractor
extends BaseAccessTokenGrantRequestExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenDeviceCodeResponseRequestExtractor.class);

    public AccessTokenDeviceCodeResponseRequestExtractor(OAuth20ConfigurationContext oAuthConfigurationContext) {
        super(oAuthConfigurationContext);
    }

    @Override
    public AccessTokenRequestContext extractRequest(WebContext context) {
        String clientId = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, "client_id").orElse("");
        LOGGER.debug("Locating OAuth registered service by client id [{}]", (Object)clientId);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.getConfigurationContext().getServicesManager(), clientId);
        LOGGER.debug("Located OAuth registered service [{}]", (Object)registeredService);
        String deviceCode = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, "device_code").orElse("");
        Service service = this.getConfigurationContext().getAuthenticationBuilder().buildService(registeredService, context, false);
        LOGGER.debug("Authenticating the OAuth request indicated by [{}]", (Object)service);
        Authentication authentication = this.getConfigurationContext().getAuthenticationBuilder().build((UserProfile)new AnonymousProfile(), registeredService, context, service);
        AuditableContext audit = AuditableContext.builder().service(service).registeredService((RegisteredService)registeredService).authentication(authentication).build();
        AuditableExecutionResult accessResult = this.getConfigurationContext().getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        accessResult.throwExceptionIfNeeded();
        return AccessTokenRequestContext.builder().service(service).authentication(authentication).registeredService(registeredService).responseType(this.getResponseType()).grantType(this.getGrantType()).generateRefreshToken(registeredService != null && registeredService.isGenerateRefreshToken()).deviceCode(deviceCode).build();
    }

    public boolean supports(WebContext context) {
        String responseType = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, "response_type").map(String::valueOf).orElse("");
        String grantType = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, "grant_type").map(String::valueOf).orElse("");
        String clientId = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, "client_id").map(String::valueOf).orElse("");
        boolean validRequest = OAuth20Utils.isResponseType(responseType, OAuth20ResponseTypes.DEVICE_CODE) || OAuth20Utils.isGrantType(grantType, OAuth20GrantTypes.DEVICE_CODE);
        return validRequest && StringUtils.isNotBlank((CharSequence)clientId);
    }

    public OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.DEVICE_CODE;
    }

    public OAuth20ResponseTypes getResponseType() {
        return OAuth20ResponseTypes.DEVICE_CODE;
    }

    public boolean requestMustBeAuthenticated() {
        return false;
    }
}

