/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.config;

import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Strings;
import com.okta.sdk.impl.config.EnvVarNameConverter;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultEnvVarNameConverter
implements EnvVarNameConverter {
    private final Map<String, String> envToDotPropMap = this.buildReverseLookupToMap("okta.client.cache.defaultTtl", "okta.client.cache.defaultTti", "okta.client.orgUrl", "okta.client.connectionTimeout", "okta.client.authenticationScheme", "okta.client.requestTimeout", "okta.client.rateLimit.maxRetries", "okta.testing.disableHttpsCheck", "okta.client.authorizationMode", "okta.client.clientId", "okta.client.scopes", "okta.client.privateKey");

    private Map<String, String> buildReverseLookupToMap(String ... dottedPropertyNames) {
        return Arrays.stream(dottedPropertyNames).collect(Collectors.toMap(this::toEnvVarName, dottedPropertyName -> dottedPropertyName));
    }

    @Override
    public String toEnvVarName(String dottedPropertyName) {
        Assert.hasText((String)dottedPropertyName, (String)"dottedPropertyName argument cannot be null or empty.");
        dottedPropertyName = Strings.trimWhitespace((String)dottedPropertyName);
        StringBuilder sb = new StringBuilder();
        for (char c : dottedPropertyName.toCharArray()) {
            if (c == '.') {
                sb.append('_');
                continue;
            }
            sb.append(Character.toUpperCase(c));
        }
        return sb.toString();
    }

    @Override
    public String toDottedPropertyName(String envVarName) {
        Assert.hasText((String)envVarName, (String)"envVarName argument cannot be null or empty.");
        envVarName = Strings.trimWhitespace((String)envVarName);
        if (this.envToDotPropMap.containsKey(envVarName)) {
            return this.envToDotPropMap.get(envVarName);
        }
        StringBuilder sb = new StringBuilder();
        for (char c : envVarName.toCharArray()) {
            if (c == '_') {
                sb.append('.');
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }
}

