/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects.filter;

import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.filter.SingleValueAttributeFilter;

public abstract class ComparableAttributeFilter
extends SingleValueAttributeFilter {
    ComparableAttributeFilter(Attribute attr) {
        super(attr);
        if (!(this.getValue() instanceof Comparable)) {
            throw new IllegalArgumentException("Must be a comparable value!");
        }
    }

    public int compare(ConnectorObject obj) {
        int ret = -1;
        Attribute attr = obj.getAttributeByName(this.getName());
        if (attr != null && attr.getValue().size() == 1) {
            if (!(attr.getValue().get(0) instanceof Comparable)) {
                throw new IllegalArgumentException("Attribute value must be comparable!");
            }
            Object o1 = attr.getValue().get(0);
            Object o2 = this.getValue();
            ret = CollectionUtil.forceCompare(o1, o2);
        }
        return ret;
    }
}

