/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.extensions;

import net.sf.jasperreports.components.iconlabel.IconLabelElementCsvHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementDocxHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementGraphics2DHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementHtmlHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementOdsHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementOdtHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementPptxHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementRtfHandler;
import net.sf.jasperreports.components.iconlabel.IconLabelElementXlsxHandler;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.export.GenericElementHandler;
import net.sf.jasperreports.engine.export.GenericElementHandlerBundle;
import net.sf.jasperreports.engine.query.DefaultQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.scriptlets.DefaultScriptletFactory;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactory;
import net.sf.jasperreports.engine.util.MessageProviderFactory;
import net.sf.jasperreports.engine.util.ResourceBundleMessageProviderFactory;
import net.sf.jasperreports.engine.xml.JacksonReportLoader;
import net.sf.jasperreports.engine.xml.JacksonReportWriterFactory;
import net.sf.jasperreports.engine.xml.ReportLoader;
import net.sf.jasperreports.engine.xml.ReportWriterFactory;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsRegistryFactory;
import net.sf.jasperreports.extensions.ListExtensionsRegistry;

public class DefaultExtensionsRegistryFactory
implements ExtensionsRegistryFactory {
    private static final GenericElementHandlerBundle HANDLER_BUNDLE = new GenericElementHandlerBundle(){

        @Override
        public String getNamespace() {
            return "http://jasperreports.sourceforge.net/jasperreports";
        }

        @Override
        public GenericElementHandler getHandler(String elementName, String exporterKey) {
            if ("iconLabel".equals(elementName)) {
                switch (exporterKey) {
                    case "net.sf.jasperreports.graphics2d": {
                        return IconLabelElementGraphics2DHandler.getInstance();
                    }
                    case "net.sf.jasperreports.html": {
                        return IconLabelElementHtmlHandler.getInstance();
                    }
                    case "net.sf.jasperreports.csv": {
                        return IconLabelElementCsvHandler.getInstance();
                    }
                    case "net.sf.jasperreports.xlsx": {
                        return IconLabelElementXlsxHandler.getInstance();
                    }
                    case "net.sf.jasperreports.docx": {
                        return IconLabelElementDocxHandler.getInstance();
                    }
                    case "net.sf.jasperreports.pptx": {
                        return IconLabelElementPptxHandler.getInstance();
                    }
                    case "net.sf.jasperreports.ods": {
                        return IconLabelElementOdsHandler.getInstance();
                    }
                    case "net.sf.jasperreports.odt": {
                        return IconLabelElementOdtHandler.getInstance();
                    }
                    case "net.sf.jasperreports.rtf": {
                        return IconLabelElementRtfHandler.getInstance();
                    }
                }
            }
            return null;
        }
    };
    private static final ExtensionsRegistry REGISTRY;

    @Override
    public ExtensionsRegistry createRegistry(String registryId, JRPropertiesMap properties) {
        return REGISTRY;
    }

    static {
        ListExtensionsRegistry registry = new ListExtensionsRegistry();
        registry.add(JRQueryExecuterFactoryBundle.class, DefaultQueryExecuterFactoryBundle.getInstance());
        registry.add(ScriptletFactory.class, DefaultScriptletFactory.getInstance());
        registry.add(GenericElementHandlerBundle.class, HANDLER_BUNDLE);
        registry.add(MessageProviderFactory.class, ResourceBundleMessageProviderFactory.getInstance());
        registry.add(ReportLoader.class, JacksonReportLoader.instance());
        registry.add(ReportWriterFactory.class, JacksonReportWriterFactory.instance());
        REGISTRY = registry;
    }
}

