/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.guard;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sf.oval.Check;
import net.sf.oval.CheckExclusion;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.Validator;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.context.ConstructorParameterContext;
import net.sf.oval.context.MethodEntryContext;
import net.sf.oval.context.MethodExitContext;
import net.sf.oval.context.MethodParameterContext;
import net.sf.oval.context.MethodReturnValueContext;
import net.sf.oval.context.OValContext;
import net.sf.oval.exception.ConstraintsViolatedException;
import net.sf.oval.exception.InvalidConfigurationException;
import net.sf.oval.exception.OValException;
import net.sf.oval.exception.ValidationFailedException;
import net.sf.oval.expression.ExpressionLanguage;
import net.sf.oval.guard.ConstraintsViolatedListener;
import net.sf.oval.guard.ParameterNameResolver;
import net.sf.oval.guard.PostCheck;
import net.sf.oval.guard.PreCheck;
import net.sf.oval.guard.ProbeModeListener;
import net.sf.oval.internal.ClassChecks;
import net.sf.oval.internal.ContextCache;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.ParameterChecks;
import net.sf.oval.internal.util.ArrayUtils;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.internal.util.CollectionUtils;
import net.sf.oval.internal.util.ConcurrentMultiValueMap;
import net.sf.oval.internal.util.IdentityHashSet;
import net.sf.oval.internal.util.Invocable;
import net.sf.oval.internal.util.ReflectionUtils;

public class Guard
extends Validator {
    protected static final PreCheck[] EMPTY_PRE_CHECKS = new PreCheck[0];
    protected static final PostCheck[] EMPTY_POST_CHECKS = new PostCheck[0];
    protected static final GuardMethodPreResult DO_NOT_PROCEED = new GuardMethodPreResult(null, null, null, null, false, null, null);
    private static final Log LOG = Log.getLog(Guard.class);
    private static final ThreadLocal<List<String>> CURRENTLY_CHECKED_METHOD_RETURN_VALUES = ThreadLocal.withInitial(() -> Guard.getCollectionFactory().createList());
    private static final ThreadLocal<List<String>> CURRENTLY_CHECKED_PRE_CONDITIONS = ThreadLocal.withInitial(() -> Guard.getCollectionFactory().createList());
    private static final ThreadLocal<List<String>> CURRENTLY_CHECKED_POST_CONDITIONS = ThreadLocal.withInitial(() -> Guard.getCollectionFactory().createList());
    private boolean isActivated = true;
    private boolean isInvariantsEnabled = true;
    private boolean isPreConditionsEnabled = true;
    private boolean isPostConditionsEnabled = true;
    private boolean isListenersFeatureUsed = false;
    private boolean isProbeModeFeatureUsed = false;
    private final Set<ConstraintsViolatedListener> listeners = new IdentityHashSet<ConstraintsViolatedListener>(4);
    private final ConcurrentMultiValueMap<Class<?>, ConstraintsViolatedListener> listenersByClass = ConcurrentMultiValueMap.create();
    private final ConcurrentMultiValueMap<Object, ConstraintsViolatedListener> listenersByObject = ConcurrentMultiValueMap.create();
    private final ThreadLocal<WeakHashMap<Object, ProbeModeListener>> objectsInProbeMode = ThreadLocal.withInitial(WeakHashMap::new);

    public Guard() {
    }

    public Guard(Collection<Configurer> configurers) {
        super(configurers);
    }

    public Guard(Configurer ... configurers) {
        super(configurers);
    }

    private List<CheckExclusion> _getActiveExclusions(Set<CheckExclusion> exclusions) {
        LinkedList<CheckExclusion> activeExclusions = new LinkedList<CheckExclusion>(exclusions);
        Iterator it = activeExclusions.iterator();
        while (it.hasNext()) {
            CheckExclusion exclusion = (CheckExclusion)it.next();
            if (this.isAnyProfileEnabled(exclusion.getProfiles(), null)) continue;
            it.remove();
        }
        return activeExclusions.isEmpty() ? null : activeExclusions;
    }

    private void _validateParameterChecks(ParameterChecks checks, Object validatedObject, Object valueToValidate, OValContext context, Validator.InternalValidationCycle cycle) {
        List<CheckExclusion> activeExclusions = checks.hasExclusions() ? this._getActiveExclusions(checks.checkExclusions) : null;
        for (Check check : checks.checks) {
            boolean skip = false;
            if (activeExclusions != null) {
                for (CheckExclusion exclusion : activeExclusions) {
                    if (!exclusion.isActive(validatedObject, valueToValidate, this) || !exclusion.isCheckExcluded(check, validatedObject, valueToValidate, context, this)) continue;
                    skip = true;
                }
            }
            if (skip) continue;
            this.checkConstraint(check, validatedObject, valueToValidate, context, cycle, false);
        }
    }

    public void addCheckExclusions(Constructor<?> ctor, int paramIndex, CheckExclusion ... exclusions) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.argumentNotNull("ctor", ctor);
        Assert.argumentNotEmpty("exclusions", exclusions);
        this.getClassChecks(ctor.getDeclaringClass()).addConstructorParameterCheckExclusions(ctor, paramIndex, exclusions);
    }

    public void addCheckExclusions(Method method, int paramIndex, CheckExclusion ... exclusions) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.argumentNotNull("method", method);
        Assert.argumentNotEmpty("exclusions", exclusions);
        this.getClassChecks(method.getDeclaringClass()).addMethodParameterCheckExclusions(method, paramIndex, exclusions);
    }

    public void addChecks(Constructor<?> ctor, int paramIndex, Check ... checks) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.argumentNotNull("ctor", ctor);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(ctor.getDeclaringClass()).addConstructorParameterChecks(ctor, paramIndex, checks);
    }

    @Override
    public void addChecks(Method method, Check ... checks) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.argumentNotNull("method", method);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(method.getDeclaringClass()).addMethodReturnValueChecks(method, null, checks);
    }

    public void addChecks(Method method, int paramIndex, Check ... checks) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.argumentNotNull("method", method);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(method.getDeclaringClass()).addMethodParameterChecks(method, paramIndex, checks);
    }

    public void addChecks(Method method, PostCheck ... checks) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.argumentNotNull("method", method);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(method.getDeclaringClass()).addMethodPostChecks(method, checks);
    }

    public void addChecks(Method method, PreCheck ... checks) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.argumentNotNull("method", method);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(method.getDeclaringClass()).addMethodPreChecks(method, checks);
    }

    public boolean addListener(ConstraintsViolatedListener listener) throws IllegalArgumentException {
        Assert.argumentNotNull("listener", listener);
        this.isListenersFeatureUsed = true;
        return this.listeners.add(listener);
    }

    public boolean addListener(ConstraintsViolatedListener listener, Class<?> guardedClass) throws IllegalArgumentException {
        Assert.argumentNotNull("listener", listener);
        Assert.argumentNotNull("guardedClass", guardedClass);
        this.isListenersFeatureUsed = true;
        return this.listenersByClass.add(guardedClass, listener);
    }

    public boolean addListener(ConstraintsViolatedListener listener, Object guardedObject) {
        Assert.argumentNotNull("listener", listener);
        Assert.argumentNotNull("guardedObject", guardedObject);
        this.isListenersFeatureUsed = true;
        return this.listenersByObject.add(guardedObject, listener);
    }

    protected Map<PostCheck, Object> calculateMethodPostOldValues(Object validatedObject, Method method, Object[] args) throws ValidationFailedException {
        Set<PostCheck> postChecks;
        block7: {
            ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
            postChecks = cc.checksForMethodsPostExcecution.get(method);
            if (postChecks != null) break block7;
            return null;
        }
        try {
            String[] parameterNames = this.parameterNameResolver.getParameterNames(method);
            boolean hasParameters = parameterNames.length > 0;
            Map<PostCheck, Object> oldValues = Guard.getCollectionFactory().createMap(postChecks.size());
            for (PostCheck check : postChecks) {
                if (!this.isAnyProfileEnabled(check.getProfiles(), null) || check.getOld() == null || check.getOld().length() <= 0) continue;
                ExpressionLanguage el = this.expressionLanguageRegistry.getExpressionLanguage(check.getLang());
                Map values = Guard.getCollectionFactory().createMap();
                values.put("_this", validatedObject);
                if (hasParameters) {
                    values.put("_args", args);
                    int i = 0;
                    while (i < args.length) {
                        values.put(parameterNames[i], args[i]);
                        ++i;
                    }
                } else {
                    values.put("_args", ArrayUtils.EMPTY_OBJECT_ARRAY);
                }
                oldValues.put(check, el.evaluate(check.getOld(), values));
            }
            return oldValues;
        }
        catch (OValException ex) {
            throw new ValidationFailedException("Method post conditions validation failed. Method: " + method + " Validated object: " + validatedObject, ex);
        }
    }

    public ProbeModeListener disableProbeMode(Object guardedObject) throws IllegalArgumentException, IllegalStateException {
        Assert.argumentNotNull("guardedObject", guardedObject);
        return this.objectsInProbeMode.get().remove(guardedObject);
    }

    public void enableProbeMode(Object guardedObject) throws IllegalArgumentException, IllegalStateException {
        Assert.argumentNotNull("guardedObject", guardedObject);
        if (guardedObject instanceof Class) {
            LOG.warn("Enabling probe mode for a class looks like a programming error. Class: {1}", guardedObject);
        }
        this.isProbeModeFeatureUsed = true;
        if (this.objectsInProbeMode.get().get(guardedObject) != null) {
            throw new IllegalStateException("The object is already in probe mode.");
        }
        this.objectsInProbeMode.get().put(guardedObject, new ProbeModeListener(guardedObject));
    }

    public Check[] getChecks(Method method, int paramIndex) throws InvalidConfigurationException {
        Assert.argumentNotNull("method", method);
        ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
        Map<Integer, ParameterChecks> checks = cc.checksForMethodParameters.get(method);
        if (checks == null) {
            return Validator.EMPTY_CHECKS;
        }
        ParameterChecks paramChecks = checks.get(paramIndex);
        return paramChecks == null ? Validator.EMPTY_CHECKS : paramChecks.checks.toArray(new Check[checks.size()]);
    }

    public PostCheck[] getChecksPost(Method method) throws IllegalArgumentException {
        Assert.argumentNotNull("method", method);
        ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
        Set<PostCheck> checks = cc.checksForMethodsPostExcecution.get(method);
        return checks == null ? EMPTY_POST_CHECKS : checks.toArray(new PostCheck[checks.size()]);
    }

    public PreCheck[] getChecksPre(Method method) throws IllegalArgumentException {
        Assert.argumentNotNull("method", method);
        ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
        Set<PreCheck> checks = cc.checksForMethodsPreExecution.get(method);
        return checks == null ? EMPTY_PRE_CHECKS : checks.toArray(new PreCheck[checks.size()]);
    }

    public ParameterNameResolver getParameterNameResolver() {
        return this.parameterNameResolver;
    }

    protected void guardConstructorPost(Object guardedObject, Constructor<?> ctor, Object[] args) throws ConstraintsViolatedException, ValidationFailedException {
        if (!this.isActivated) {
            return;
        }
        ClassChecks cc = this.getClassChecks(ctor.getDeclaringClass());
        if (this.isInvariantsEnabled && cc.isCheckInvariants || cc.methodsWithCheckInvariantsPost.contains(ctor)) {
            Validator.InternalValidationCycle cycle = new Validator.InternalValidationCycle(guardedObject, null);
            ((LinkedList)this.currentValidationCycles.get()).add(cycle);
            try {
                try {
                    this.validateInvariants(guardedObject, cycle);
                }
                catch (ValidationFailedException ex) {
                    throw this.translateException(ex);
                }
            }
            finally {
                ((LinkedList)this.currentValidationCycles.get()).removeLast();
            }
            if (!cycle.violations.isEmpty()) {
                ConstraintsViolatedException violationException = new ConstraintsViolatedException(cycle.violations);
                if (this.isListenersFeatureUsed) {
                    this.notifyListeners(guardedObject, violationException);
                }
                throw this.translateException(violationException);
            }
        }
    }

    protected void guardConstructorPre(Object guardedObject, Constructor<?> ctor, Object[] args) throws ConstraintsViolatedException, ValidationFailedException {
        if (!this.isActivated) {
            return;
        }
        if (this.isPreConditionsEnabled && args.length > 0) {
            List<ConstraintViolation> violations;
            try {
                violations = this.validateConstructorParameters(guardedObject, ctor, args);
            }
            catch (ValidationFailedException ex) {
                throw this.translateException(ex);
            }
            if (violations != null) {
                ConstraintsViolatedException violationException = new ConstraintsViolatedException(violations);
                if (this.isListenersFeatureUsed) {
                    this.notifyListeners(guardedObject, violationException);
                }
                throw this.translateException(violationException);
            }
        }
    }

    protected Object guardMethod(Object guardedObject, Method method, Object[] args, Invocable<Object, Throwable> invocable) throws Throwable {
        ProbeModeListener pml;
        boolean checkInvariants;
        if (!this.isActivated) {
            return invocable.invoke();
        }
        ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
        boolean bl = checkInvariants = this.isInvariantsEnabled && cc.isCheckInvariants && !ReflectionUtils.isPrivate(method) && !ReflectionUtils.isProtected(method);
        if (guardedObject == null && ReflectionUtils.isStatic(method)) {
            guardedObject = method.getDeclaringClass();
        }
        Validator.InternalValidationCycle cycle = new Validator.InternalValidationCycle(guardedObject, null);
        ((LinkedList)this.currentValidationCycles.get()).add(cycle);
        try {
            try {
                if (checkInvariants || cc.methodsWithCheckInvariantsPre.contains(method)) {
                    this.validateInvariants(guardedObject, cycle);
                }
                if (this.isPreConditionsEnabled) {
                    if (args.length > 0 && cycle.violations.isEmpty()) {
                        this.validateMethodParameters(guardedObject, method, args, cycle);
                    }
                    if (cycle.violations.isEmpty()) {
                        this.validateMethodPre(guardedObject, method, args, cycle);
                    }
                }
            }
            catch (ValidationFailedException ex) {
                throw this.translateException(ex);
            }
        }
        finally {
            ((LinkedList)this.currentValidationCycles.get()).removeLast();
        }
        ProbeModeListener probeModeListener = pml = this.isProbeModeFeatureUsed ? this.objectsInProbeMode.get().get(guardedObject) : null;
        if (pml != null) {
            pml.onMethodCall(method, args);
        }
        if (!cycle.violations.isEmpty()) {
            ConstraintsViolatedException violationException = new ConstraintsViolatedException(cycle.violations);
            if (this.isListenersFeatureUsed) {
                this.notifyListeners(guardedObject, violationException);
            }
            if (pml != null) {
                pml.onConstraintsViolatedException(violationException);
                return null;
            }
            throw this.translateException(violationException);
        }
        if (pml != null) {
            return null;
        }
        Map<PostCheck, Object> postCheckOldValues = this.calculateMethodPostOldValues(guardedObject, method, args);
        Object returnValue = invocable.invoke();
        ((LinkedList)this.currentValidationCycles.get()).add(cycle);
        try {
            try {
                if (checkInvariants || cc.methodsWithCheckInvariantsPost.contains(method)) {
                    this.validateInvariants(guardedObject, cycle);
                }
                if (this.isPostConditionsEnabled) {
                    if (cycle.violations.isEmpty()) {
                        this.validateMethodReturnValue(guardedObject, method, returnValue, cycle);
                    }
                    if (cycle.violations.isEmpty()) {
                        this.validateMethodPost(guardedObject, method, args, returnValue, postCheckOldValues, cycle);
                    }
                }
            }
            catch (ValidationFailedException ex) {
                throw this.translateException(ex);
            }
        }
        finally {
            ((LinkedList)this.currentValidationCycles.get()).removeLast();
        }
        if (!cycle.violations.isEmpty()) {
            ConstraintsViolatedException violationException = new ConstraintsViolatedException(cycle.violations);
            if (this.isListenersFeatureUsed) {
                this.notifyListeners(guardedObject, violationException);
            }
            throw this.translateException(violationException);
        }
        return returnValue;
    }

    protected void guardMethodPost(Object returnValue, GuardMethodPreResult preResult) throws ConstraintsViolatedException, ValidationFailedException {
        if (!this.isActivated) {
            return;
        }
        ((LinkedList)this.currentValidationCycles.get()).add(preResult.cycle);
        try {
            try {
                if (preResult.checkInvariants || preResult.cc.methodsWithCheckInvariantsPost.contains(preResult.method)) {
                    this.validateInvariants(preResult.guardedObject, preResult.cycle);
                }
                if (this.isPostConditionsEnabled) {
                    if (preResult.cycle.violations.isEmpty()) {
                        this.validateMethodReturnValue(preResult.guardedObject, preResult.method, returnValue, preResult.cycle);
                    }
                    if (preResult.cycle.violations.isEmpty()) {
                        this.validateMethodPost(preResult.guardedObject, preResult.method, preResult.args, returnValue, preResult.postCheckOldValues, preResult.cycle);
                    }
                }
            }
            catch (ValidationFailedException ex) {
                throw this.translateException(ex);
            }
        }
        finally {
            ((LinkedList)this.currentValidationCycles.get()).removeLast();
        }
        if (!preResult.cycle.violations.isEmpty()) {
            ConstraintsViolatedException violationException = new ConstraintsViolatedException(preResult.cycle.violations);
            if (this.isListenersFeatureUsed) {
                this.notifyListeners(preResult.guardedObject, violationException);
            }
            throw this.translateException(violationException);
        }
    }

    protected GuardMethodPreResult guardMethodPre(Object guardedObject, Method method, Object[] args) throws ConstraintsViolatedException, ValidationFailedException {
        ProbeModeListener pml;
        boolean checkInvariants;
        if (!this.isActivated) {
            return null;
        }
        ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
        boolean bl = checkInvariants = this.isInvariantsEnabled && cc.isCheckInvariants && !ReflectionUtils.isPrivate(method) && !ReflectionUtils.isProtected(method);
        if (guardedObject == null && ReflectionUtils.isStatic(method)) {
            guardedObject = method.getDeclaringClass();
        }
        Validator.InternalValidationCycle cycle = new Validator.InternalValidationCycle(guardedObject, null);
        ((LinkedList)this.currentValidationCycles.get()).add(cycle);
        try {
            try {
                if (checkInvariants || cc.methodsWithCheckInvariantsPre.contains(method)) {
                    this.validateInvariants(guardedObject, cycle);
                }
                if (this.isPreConditionsEnabled) {
                    if (args.length > 0 && cycle.violations.isEmpty()) {
                        this.validateMethodParameters(guardedObject, method, args, cycle);
                    }
                    if (cycle.violations.isEmpty()) {
                        this.validateMethodPre(guardedObject, method, args, cycle);
                    }
                }
            }
            catch (ValidationFailedException ex) {
                throw this.translateException(ex);
            }
        }
        finally {
            ((LinkedList)this.currentValidationCycles.get()).removeLast();
        }
        ProbeModeListener probeModeListener = pml = this.isProbeModeFeatureUsed ? this.objectsInProbeMode.get().get(guardedObject) : null;
        if (pml != null) {
            pml.onMethodCall(method, args);
        }
        if (!cycle.violations.isEmpty()) {
            ConstraintsViolatedException violationException = new ConstraintsViolatedException(cycle.violations);
            if (this.isListenersFeatureUsed) {
                this.notifyListeners(guardedObject, violationException);
            }
            if (pml != null) {
                pml.onConstraintsViolatedException(violationException);
                return DO_NOT_PROCEED;
            }
            throw this.translateException(violationException);
        }
        if (pml != null) {
            return DO_NOT_PROCEED;
        }
        Map<PostCheck, Object> postCheckOldValues = this.calculateMethodPostOldValues(guardedObject, method, args);
        return new GuardMethodPreResult(guardedObject, method, args, cc, checkInvariants, postCheckOldValues, cycle);
    }

    public boolean hasListener(ConstraintsViolatedListener listener) throws IllegalArgumentException {
        Assert.argumentNotNull("listener", listener);
        return this.listeners.contains(listener);
    }

    public boolean hasListener(ConstraintsViolatedListener listener, Class<?> guardedClass) throws IllegalArgumentException {
        Assert.argumentNotNull("listener", listener);
        Assert.argumentNotNull("guardedClass", guardedClass);
        return this.listenersByClass.containsValue(guardedClass, listener);
    }

    public boolean hasListener(ConstraintsViolatedListener listener, Object guardedObject) throws IllegalArgumentException {
        Assert.argumentNotNull("listener", listener);
        Assert.argumentNotNull("guardedObject", guardedObject);
        return this.listenersByObject.containsValue(guardedObject, listener);
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public boolean isInProbeMode(Object guardedObject) {
        if (guardedObject == null) {
            return false;
        }
        return this.objectsInProbeMode.get().containsKey(guardedObject);
    }

    public boolean isInvariantsEnabled() {
        return this.isInvariantsEnabled;
    }

    public boolean isInvariantsEnabled(Class<?> guardedClass) {
        return this.getClassChecks(guardedClass).isCheckInvariants;
    }

    public boolean isPostConditionsEnabled() {
        return this.isPostConditionsEnabled;
    }

    public boolean isPreConditionsEnabled() {
        return this.isPreConditionsEnabled;
    }

    protected void notifyListeners(Object guardedObject, ConstraintsViolatedException ex) {
        if (guardedObject == null) {
            return;
        }
        LinkedHashSet<ConstraintsViolatedListener> listenersToNotify = new LinkedHashSet<ConstraintsViolatedListener>();
        this.listenersByObject.addAllTo(guardedObject, listenersToNotify);
        this.listenersByClass.addAllTo(guardedObject.getClass(), listenersToNotify);
        Class<?>[] classArray = guardedObject.getClass().getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            this.listenersByClass.addAllTo(iface, listenersToNotify);
            ++n2;
        }
        listenersToNotify.addAll(this.listeners);
        for (ConstraintsViolatedListener listener : listenersToNotify) {
            try {
                listener.onConstraintsViolatedException(ex);
            }
            catch (RuntimeException rex) {
                LOG.warn("Notifying listener '{1}' failed.", (Object)listener, rex);
            }
        }
    }

    public void removeCheckExclusions(Constructor<?> ctor, int paramIndex, CheckExclusion ... exclusions) throws InvalidConfigurationException {
        Assert.argumentNotNull("ctor", ctor);
        Assert.argumentNotEmpty("exclusions", exclusions);
        this.getClassChecks(ctor.getDeclaringClass()).removeConstructorParameterCheckExclusions(ctor, paramIndex, exclusions);
    }

    public void removeCheckExclusions(Method method, int paramIndex, CheckExclusion ... exclusions) throws InvalidConfigurationException {
        Assert.argumentNotNull("method", method);
        Assert.argumentNotEmpty("exclusions", exclusions);
        this.getClassChecks(method.getDeclaringClass()).removeMethodParameterCheckExclusions(method, paramIndex, exclusions);
    }

    public void removeChecks(Constructor<?> ctor, int paramIndex, Check ... checks) throws InvalidConfigurationException {
        Assert.argumentNotNull("ctor", ctor);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(ctor.getDeclaringClass()).removeConstructorParameterChecks(ctor, paramIndex, checks);
    }

    public void removeChecks(Method method, int paramIndex, Check ... checks) throws InvalidConfigurationException {
        Assert.argumentNotNull("method", method);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(method.getDeclaringClass()).removeMethodParameterChecks(method, paramIndex, checks);
    }

    public void removeChecks(Method method, PostCheck ... checks) throws InvalidConfigurationException {
        Assert.argumentNotNull("method", method);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(method.getDeclaringClass()).removeMethodPostChecks(method, checks);
    }

    public void removeChecks(Method method, PreCheck ... checks) throws InvalidConfigurationException {
        Assert.argumentNotNull("method", method);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(method.getDeclaringClass()).removeMethodPreChecks(method, checks);
    }

    public boolean removeListener(ConstraintsViolatedListener listener) throws IllegalArgumentException {
        Assert.argumentNotNull("listener", listener);
        return this.listeners.remove(listener);
    }

    public boolean removeListener(ConstraintsViolatedListener listener, Class<?> guardedClass) throws IllegalArgumentException {
        Assert.argumentNotNull("listener", listener);
        Assert.argumentNotNull("guardedClass", guardedClass);
        return this.listenersByClass.remove(guardedClass, listener);
    }

    public boolean removeListener(ConstraintsViolatedListener listener, Object guardedObject) throws IllegalArgumentException {
        Assert.argumentNotNull("listener", listener);
        Assert.argumentNotNull("guardedObject", guardedObject);
        return this.listenersByObject.remove(guardedObject, listener);
    }

    public void setActivated(boolean isActivated) {
        this.isActivated = isActivated;
    }

    public void setInvariantsEnabled(boolean isEnabled) {
        this.isInvariantsEnabled = isEnabled;
    }

    public void setInvariantsEnabled(Class<?> guardedClass, boolean isEnabled) {
        this.getClassChecks(guardedClass).isCheckInvariants = isEnabled;
    }

    public void setParameterNameResolver(ParameterNameResolver parameterNameResolver) throws IllegalArgumentException {
        Assert.argumentNotNull("parameterNameResolver", parameterNameResolver);
        this.parameterNameResolver.setDelegate(parameterNameResolver);
    }

    public void setPostConditionsEnabled(boolean isEnabled) {
        this.isPostConditionsEnabled = isEnabled;
    }

    public void setPreConditionsEnabled(boolean isEnabled) {
        this.isPreConditionsEnabled = isEnabled;
    }

    protected List<ConstraintViolation> validateConstructorParameters(Object validatedObject, Constructor<?> constructor, Object[] argsToValidate) throws ValidationFailedException {
        Validator.InternalValidationCycle cycle = new Validator.InternalValidationCycle(validatedObject, null);
        ((LinkedList)this.currentValidationCycles.get()).add(cycle);
        try {
            ClassChecks cc = this.getClassChecks(constructor.getDeclaringClass());
            Map<Integer, ParameterChecks> parameterChecks = cc.checksForConstructorParameters.get(constructor);
            if (parameterChecks == null) {
                return null;
            }
            String[] parameterNames = this.parameterNameResolver.getParameterNames(constructor);
            int i = 0;
            while (i < argsToValidate.length) {
                ParameterChecks checks = parameterChecks.get(i);
                if (checks != null && checks.hasChecks()) {
                    Object valueToValidate = argsToValidate[i];
                    ConstructorParameterContext context = new ConstructorParameterContext(constructor, i, parameterNames[i]);
                    this._validateParameterChecks(checks, validatedObject, valueToValidate, context, cycle);
                }
                ++i;
            }
            List<ConstraintViolation> list = cycle.violations.isEmpty() ? null : cycle.violations;
            return list;
        }
        catch (OValException ex) {
            throw new ValidationFailedException("Validation of constructor parameters failed. Constructor: " + constructor + " Validated object: " + validatedObject.getClass().getName() + "@" + Integer.toHexString(validatedObject.hashCode()), ex);
        }
        finally {
            ((LinkedList)this.currentValidationCycles.get()).removeLast();
        }
    }

    @Override
    protected void validateInvariants(Object guardedObject, Validator.InternalValidationCycle cycle) throws IllegalArgumentException, ValidationFailedException {
        List validationCycles = (List)this.currentValidationCycles.get();
        if (validationCycles.size() > 1 && ((Validator.InternalValidationCycle)validationCycles.get((int)(validationCycles.size() - 2))).validatedObjects.contains(guardedObject)) {
            return;
        }
        IdentityHashSet<Object> validatedObjects = cycle.validatedObjects;
        cycle.validatedObjects = new IdentityHashSet(4);
        try {
            super.validateInvariants(guardedObject, cycle);
        }
        finally {
            cycle.validatedObjects = validatedObjects;
        }
    }

    @Deprecated
    protected void validateMethodParameters(Object validatedObject, Method method, Object[] args, List<ConstraintViolation> violations) throws ValidationFailedException {
        Validator.InternalValidationCycle cycle = new Validator.InternalValidationCycle(validatedObject, null);
        cycle.violations = violations;
        this.validateMethodParameters(validatedObject, method, args, cycle);
    }

    protected void validateMethodParameters(Object validatedObject, Method method, Object[] args, Validator.InternalValidationCycle cycle) throws ValidationFailedException {
        IdentityHashSet<Object> validatedObjects = cycle.validatedObjects;
        cycle.validatedObjects = new IdentityHashSet(4);
        try {
            ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
            Map<Integer, ParameterChecks> parameterChecks = cc.checksForMethodParameters.get(method);
            if (parameterChecks == null) {
                return;
            }
            try {
                String[] parameterNames = this.parameterNameResolver.getParameterNames(method);
                if (parameterNames.length > 0) {
                    int i = 0;
                    while (i < args.length) {
                        ParameterChecks checks = parameterChecks.get(i);
                        if (checks != null && !checks.checks.isEmpty()) {
                            Object valueToValidate = args[i];
                            MethodParameterContext context = new MethodParameterContext(method, i, parameterNames[i]);
                            this._validateParameterChecks(checks, validatedObject, valueToValidate, context, cycle);
                        }
                        ++i;
                    }
                }
            }
            catch (OValException ex) {
                throw new ValidationFailedException("Method pre conditions validation failed. Method: " + method + " Validated object: " + validatedObject, ex);
            }
        }
        finally {
            cycle.validatedObjects = validatedObjects;
        }
    }

    protected void validateMethodPost(Object validatedObject, Method method, Object[] args, Object returnValue, Map<PostCheck, Object> oldValues, Validator.InternalValidationCycle cycle) throws ValidationFailedException {
        String key = String.valueOf(System.identityHashCode(validatedObject)) + " " + System.identityHashCode(method);
        if (CURRENTLY_CHECKED_POST_CONDITIONS.get().contains(key)) {
            return;
        }
        CURRENTLY_CHECKED_POST_CONDITIONS.get().add(key);
        try {
            ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
            Set<PostCheck> postChecks = cc.checksForMethodsPostExcecution.get(method);
            if (postChecks == null) {
                return;
            }
            try {
                String[] parameterNames = this.parameterNameResolver.getParameterNames(method);
                boolean hasParameters = parameterNames.length > 0;
                MethodExitContext context = ContextCache.getMethodExitContext(method);
                cycle.contextPath.add(context);
                for (PostCheck check : postChecks) {
                    if (!this.isAnyProfileEnabled(check.getProfiles(), null)) continue;
                    try {
                        ExpressionLanguage eng = this.expressionLanguageRegistry.getExpressionLanguage(check.getLang());
                        Map values = Guard.getCollectionFactory().createMap();
                        values.put("_this", validatedObject);
                        values.put("_returns", returnValue);
                        values.put("_old", oldValues.get(check));
                        if (hasParameters) {
                            values.put("_args", args);
                            int i = 0;
                            while (i < args.length) {
                                values.put(parameterNames[i], args[i]);
                                ++i;
                            }
                        } else {
                            values.put("_args", ArrayUtils.EMPTY_OBJECT_ARRAY);
                        }
                        if (eng.evaluateAsBoolean(check.getExpr(), values)) continue;
                        Map messageVariables = Guard.getCollectionFactory().createMap(2);
                        messageVariables.put("expression", check.getExpr());
                        String errorMessage = this.renderMessage(cycle.contextPath, null, check.getMessage(), messageVariables);
                        cycle.addConstraintViolation(check, errorMessage, null);
                    }
                    catch (OValException ex) {
                        throw new ValidationFailedException("Executing " + check + " failed. Method: " + method + " Validated object: " + validatedObject, ex);
                    }
                }
                CollectionUtils.removeLast(cycle.contextPath, context);
            }
            catch (ValidationFailedException ex) {
                throw ex;
            }
            catch (OValException ex) {
                throw new ValidationFailedException("Method post conditions validation failed. Method: " + method + " Validated object: " + validatedObject, ex);
            }
        }
        finally {
            CURRENTLY_CHECKED_POST_CONDITIONS.get().remove(key);
        }
    }

    @Deprecated
    protected void validateMethodPre(Object validatedObject, Method method, Object[] args, List<ConstraintViolation> violations) throws ValidationFailedException {
        Validator.InternalValidationCycle cycle = new Validator.InternalValidationCycle(validatedObject, null);
        cycle.violations = violations;
        this.validateMethodPre(validatedObject, method, args, cycle);
    }

    protected void validateMethodPre(Object validatedObject, Method method, Object[] args, Validator.InternalValidationCycle cycle) throws ValidationFailedException {
        String key = String.valueOf(System.identityHashCode(validatedObject)) + " " + System.identityHashCode(method);
        if (CURRENTLY_CHECKED_PRE_CONDITIONS.get().contains(key)) {
            return;
        }
        CURRENTLY_CHECKED_PRE_CONDITIONS.get().add(key);
        try {
            ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
            Set<PreCheck> preChecks = cc.checksForMethodsPreExecution.get(method);
            if (preChecks == null) {
                return;
            }
            try {
                String[] parameterNames = this.parameterNameResolver.getParameterNames(method);
                boolean hasParameters = parameterNames.length > 0;
                MethodEntryContext context = ContextCache.getMethodEntryContext(method);
                cycle.contextPath.add(context);
                for (PreCheck check : preChecks) {
                    if (!this.isAnyProfileEnabled(check.getProfiles(), null)) continue;
                    ExpressionLanguage eng = this.expressionLanguageRegistry.getExpressionLanguage(check.getLang());
                    Map values = Guard.getCollectionFactory().createMap();
                    values.put("_this", validatedObject);
                    if (hasParameters) {
                        values.put("_args", args);
                        int i = 0;
                        while (i < args.length) {
                            values.put(parameterNames[i], args[i]);
                            ++i;
                        }
                    } else {
                        values.put("_args", ArrayUtils.EMPTY_OBJECT_ARRAY);
                    }
                    if (eng.evaluateAsBoolean(check.getExpr(), values)) continue;
                    Map messageVariables = Guard.getCollectionFactory().createMap(2);
                    messageVariables.put("expression", check.getExpr());
                    String errorMessage = this.renderMessage(cycle.contextPath, null, check.getMessage(), messageVariables);
                    cycle.addConstraintViolation(check, errorMessage, null);
                }
                CollectionUtils.removeLast(cycle.contextPath, context);
            }
            catch (OValException ex) {
                throw new ValidationFailedException("Method pre conditions validation failed. Method: " + method + " Validated object: " + validatedObject, ex);
            }
        }
        finally {
            CURRENTLY_CHECKED_PRE_CONDITIONS.get().remove(key);
        }
    }

    protected void validateMethodReturnValue(Object validatedObject, Method method, Object returnValue, Validator.InternalValidationCycle cycle) throws ValidationFailedException {
        String key = String.valueOf(System.identityHashCode(validatedObject)) + " " + System.identityHashCode(method);
        if (CURRENTLY_CHECKED_METHOD_RETURN_VALUES.get().contains(key)) {
            return;
        }
        CURRENTLY_CHECKED_METHOD_RETURN_VALUES.get().add(key);
        IdentityHashSet<Object> validatedObjects = cycle.validatedObjects;
        cycle.validatedObjects = new IdentityHashSet(4);
        try {
            ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
            Collection returnValueChecks = cc.checksForMethodReturnValues.get(method);
            if (returnValueChecks == null || returnValueChecks.isEmpty()) {
                return;
            }
            try {
                MethodReturnValueContext context = ContextCache.getMethodReturnValueContext(method);
                for (Check check : returnValueChecks) {
                    this.checkConstraint(check, validatedObject, returnValue, context, cycle, false);
                }
            }
            catch (OValException ex) {
                throw new ValidationFailedException("Method post conditions validation failed. Method: " + method + " Validated object: " + validatedObject, ex);
            }
        }
        finally {
            cycle.validatedObjects = validatedObjects;
            CURRENTLY_CHECKED_METHOD_RETURN_VALUES.get().remove(key);
        }
    }

    protected static final class GuardMethodPreResult {
        protected final boolean checkInvariants;
        protected final Method method;
        protected final Object[] args;
        protected final ClassChecks cc;
        protected final Validator.InternalValidationCycle cycle;
        protected final Map<PostCheck, Object> postCheckOldValues;
        protected final Object guardedObject;

        protected GuardMethodPreResult(Object guardedObject, Method method, Object[] args, ClassChecks cc, boolean checkInvariants, Map<PostCheck, Object> postCheckOldValues, Validator.InternalValidationCycle cycle) {
            this.guardedObject = guardedObject;
            this.method = method;
            this.args = args;
            this.cc = cc;
            this.checkInvariants = checkInvariants;
            this.postCheckOldValues = postCheckOldValues;
            this.cycle = cycle;
        }
    }
}

