/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.js;

import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Join;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Sets;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.alerts.common.NothingToCompileError;
import com.google.gxp.compiler.base.AbbrExpression;
import com.google.gxp.compiler.base.AttrBundleParam;
import com.google.gxp.compiler.base.AttrBundleReference;
import com.google.gxp.compiler.base.BooleanConstant;
import com.google.gxp.compiler.base.BoundCall;
import com.google.gxp.compiler.base.Call;
import com.google.gxp.compiler.base.CallVisitor;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.CallableVisitor;
import com.google.gxp.compiler.base.Concatenation;
import com.google.gxp.compiler.base.Conditional;
import com.google.gxp.compiler.base.ConstructedConstant;
import com.google.gxp.compiler.base.ConvertibleToContent;
import com.google.gxp.compiler.base.DefaultingExpressionVisitor;
import com.google.gxp.compiler.base.EscapeExpression;
import com.google.gxp.compiler.base.ExampleExpression;
import com.google.gxp.compiler.base.ExceptionExpression;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.ExtractedMessage;
import com.google.gxp.compiler.base.FormalParameter;
import com.google.gxp.compiler.base.FormalTypeParameter;
import com.google.gxp.compiler.base.InstanceCallable;
import com.google.gxp.compiler.base.Interface;
import com.google.gxp.compiler.base.IsXmlExpression;
import com.google.gxp.compiler.base.LoopExpression;
import com.google.gxp.compiler.base.NativeExpression;
import com.google.gxp.compiler.base.NullRoot;
import com.google.gxp.compiler.base.ObjectConstant;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.RootVisitor;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.Template;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.base.UnboundCall;
import com.google.gxp.compiler.base.UnexpectedNodeException;
import com.google.gxp.compiler.base.ValidatedCall;
import com.google.gxp.compiler.codegen.BracesCodeGenerator;
import com.google.gxp.compiler.js.LoopRequiresIterableInJavaScriptError;
import com.google.gxp.compiler.msgextract.MessageExtractedTree;
import com.google.gxp.compiler.reparent.Attribute;
import com.google.gxp.compiler.schema.AttributeValidator;
import com.google.gxp.compiler.schema.ContentFamilyVisitor;
import com.google.gxp.compiler.schema.Schema;
import com.google.transconsole.common.messages.MessageFragment;
import com.google.transconsole.common.messages.Placeholder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaScriptCodeGenerator
extends BracesCodeGenerator<MessageExtractedTree> {
    public JavaScriptCodeGenerator(MessageExtractedTree tree) {
        super(tree);
    }

    @Override
    public void generateCode(final Appendable appendable, final AlertSink alertSink) {
        alertSink.addAll(((MessageExtractedTree)this.tree).getAlerts());
        this.root.acceptVisitor(new RootVisitor<Void>(){

            @Override
            public Void visitInterface(Interface iface) {
                return null;
            }

            @Override
            public Void visitNullRoot(NullRoot nullRoot) {
                alertSink.add(new NothingToCompileError(nullRoot.getSourcePosition()));
                return null;
            }

            @Override
            public Void visitTemplate(Template template) {
                JavaScriptCodeGenerator.this.validateFormalTypeParameters(alertSink, template.getFormalTypeParameters());
                JavaScriptCodeGenerator.this.createTemplateWorker(appendable, alertSink, template).run();
                return null;
            }
        });
    }

    private void validateFormalTypeParameters(AlertSink alertSink, List<FormalTypeParameter> formalTypeParameters) {
        for (FormalTypeParameter formalTypeParameter : formalTypeParameters) {
            OutputLanguage.JAVASCRIPT.validateName(alertSink, formalTypeParameter, formalTypeParameter.getName());
        }
    }

    private TemplateWorker createTemplateWorker(Appendable appendable, AlertSink alertSink, Template template) {
        return new TemplateWorker(appendable, alertSink, template);
    }

    private static class TemplateWorker
    extends BracesCodeGenerator.Worker {
        private final Template template;
        private int varCounter = 0;
        private static final String GXP_OUT_VAR = "gxp$out";
        private static final String GXP_CONTEXT_VAR = "gxp_context";
        private static final String GXP_SIG = Join.join(", ", (Object)"gxp$out", "gxp_context");
        private Function<Parameter, String> parameterToName = new Function<Parameter, String>(){

            @Override
            public String apply(Parameter param) {
                return param.getPrimaryName();
            }
        };
        private Function<Parameter, String> parameterToMemberName = new Function<Parameter, String>(){

            @Override
            public String apply(Parameter param) {
                return "this." + param.getPrimaryName();
            }
        };
        private static final int MAX_JAVASCRIPT_STRING_LENGTH = 65534;
        protected final Deque<String> instantiatedGxps = new ArrayDeque<String>();
        private final StatementVisitor statementVisitor = this.getStatementVisitor();
        private final ExpressionVisitor<String> toExpressionVisitor = new ToExpressionVisitor();
        private final ExpressionVisitor<String> toEscapableExpressionVisitor = this.getToEscapableExpressionVisitor();
        protected Function<Expression, String> expressionToEscapedString = new Function<Expression, String>(){

            @Override
            public String apply(Expression value) {
                return TemplateWorker.this.getEscapedString(value);
            }
        };

        public TemplateWorker(Appendable appendable, AlertSink alertSink, Template template) {
            super(appendable, alertSink, new String[0]);
            this.template = Preconditions.checkNotNull(template);
        }

        public TemplateWorker createSubWorker(Appendable newAppendable) {
            return new TemplateWorker(newAppendable, this.alertSink, this.template);
        }

        public void run() {
            for (Parameter param : this.template.getAllParameters()) {
                OutputLanguage.JAVASCRIPT.validateName(this.alertSink, param, param.getPrimaryName());
            }
            this.appendHeader(this.template);
            this.appendLine();
            this.formatLine("goog.provide('%s');", this.getClassName(this.template.getName()));
            this.appendLine();
            this.appendConstructor();
            this.appendLine();
            this.appendWriteMethod();
            this.appendLine();
            this.appendGetGxpClosureMethod(false);
            this.appendLine();
            this.appendStaticWriteMethod();
            this.appendLine();
            this.appendGetGxpClosureMethod(true);
            this.appendGetDefaultMethods();
            this.appendConstructorMethods();
            this.appendLine();
            this.appendFooter();
        }

        private String getWriteMethodSignature(boolean isStatic) {
            List<Parameter> params = isStatic ? this.template.getAllParameters() : this.template.getParameters();
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClassName(this.template.getName()));
            if (!isStatic) {
                sb.append(".prototype");
            }
            sb.append(".write = function(");
            Join.join(sb, ", ", Iterables.concat(ImmutableSet.of(GXP_SIG), Iterables.transform(params, this.parameterToName)));
            sb.append(") {");
            return sb.toString();
        }

        private String getGetGxpClosureMethodSignature(boolean isStatic) {
            List<Parameter> params = isStatic ? this.template.getAllParameters() : this.template.getParameters();
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClassName(this.template.getName()));
            if (!isStatic) {
                sb.append(".prototype");
            }
            sb.append(".getGxpClosure = function(");
            Join.join(sb, ", ", Iterables.transform(params, this.parameterToName));
            sb.append(") {");
            return sb.toString();
        }

        private void appendConstructor() {
            List<Parameter> params = this.template.getConstructor().getParameters();
            this.appendLine("/**");
            this.formatLine(" * @this {%s}", this.getClassName(this.template.getName()));
            this.appendLine(" */");
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClassName(this.template.getName()));
            sb.append(" = function(");
            Join.join(sb, ", ", Iterables.transform(params, this.parameterToName));
            sb.append(") {");
            this.appendLine(sb);
            for (Parameter param : params) {
                this.formatLine("this.%s = %s;", param.getPrimaryName(), param.getPrimaryName());
            }
            this.appendLine("};");
        }

        private void appendWriteMethod() {
            List<Parameter> ctorParams = this.template.getConstructor().getParameters();
            List<Parameter> params = this.template.getParameters();
            Iterable methodParameters = Iterables.concat(ImmutableSet.of(GXP_SIG), Iterables.transform(ctorParams, this.parameterToMemberName), Iterables.transform(params, this.parameterToName));
            this.appendLine(this.getWriteMethodSignature(false));
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClassName(this.template.getName()));
            sb.append(".write(");
            Join.join(sb, ", ", methodParameters);
            sb.append(");");
            this.appendLine(sb);
            this.appendLine("};");
        }

        private void appendGetGxpClosureMethod(boolean isStatic) {
            List<Parameter> params = isStatic ? this.template.getAllParameters() : this.template.getParameters();
            this.appendLine(this.getGetGxpClosureMethodSignature(isStatic));
            String selfVar = this.createVarName("self");
            if (!isStatic) {
                this.formatLine("var %s = this;", selfVar);
            }
            this.formatLine("return new %s(function(%s) {", this.template.getSchema().getJavaScriptType(), GXP_SIG);
            StringBuilder sb = new StringBuilder();
            sb.append(isStatic ? this.getClassName(this.template.getName()) : selfVar);
            sb.append(".write(");
            Join.join(sb, ", ", Iterables.concat(ImmutableSet.of(GXP_SIG), Iterables.transform(params, this.parameterToName)));
            sb.append(");");
            this.appendLine(sb);
            this.formatLine("return %s;", GXP_OUT_VAR);
            this.appendLine("});");
            this.appendLine("};");
        }

        private void appendStaticWriteMethod() {
            this.appendLine(this.getWriteMethodSignature(true));
            this.template.getContent().acceptVisitor(this.statementVisitor);
            this.appendLine("};");
        }

        private void appendGetDefaultMethods() {
            for (Parameter param : this.template.getAllParameters()) {
                Expression defaultValue = param.getDefaultValue();
                if (defaultValue == null) continue;
                this.appendLine();
                this.formatLine(param.getDefaultValue().getSourcePosition(), "%s.GXP_DEFAULT$%s = %s;", this.getClassName(this.template.getName()), param.getPrimaryName(), this.getJavaScriptExpression(param.getDefaultValue()));
                this.appendLine();
                String methodName = JavaScriptCodeGenerator.getDefaultMethodName(param);
                this.formatLine("%s.%s = function() {", this.getClassName(this.template.getName()), methodName);
                this.formatLine("return %s.GXP_DEFAULT$%s;", this.getClassName(this.template.getName()), param.getPrimaryName());
                this.appendLine("};");
            }
            for (Parameter param : this.template.getParameters()) {
                if (param.getDefaultValue() == null) continue;
                String methodName = JavaScriptCodeGenerator.getDefaultMethodName(param);
                this.appendLine();
                this.formatLine("%s.prototype.%s = function() {", this.getClassName(this.template.getName()), methodName);
                this.formatLine("return %s.%s();", this.getClassName(this.template.getName()), methodName);
                this.appendLine("};");
            }
        }

        private void appendConstructorMethods() {
            String methodName;
            for (Parameter param : this.template.getAllParameters()) {
                if (param.getConstructor() == null) continue;
                methodName = JavaScriptCodeGenerator.getConstructorMethodName(param);
                this.appendLine();
                this.formatLine("%s.%s = function(%s) {", this.getClassName(this.template.getName()), methodName, param.getPrimaryName());
                this.formatLine(param.getSourcePosition(), "return %s;", param.getConstructor().acceptVisitor(this.toExpressionVisitor));
                this.appendLine("};");
            }
            for (Parameter param : this.template.getParameters()) {
                if (param.getConstructor() == null) continue;
                methodName = JavaScriptCodeGenerator.getConstructorMethodName(param);
                this.appendLine();
                this.formatLine("%s.prototype.%s = function(%s) {", this.getClassName(this.template.getName()), methodName, param.getPrimaryName());
                this.formatLine("return %s.%s(%s);", this.getClassName(this.template.getName()), methodName, param.getPrimaryName());
                this.appendLine("};");
            }
        }

        protected final String createVarName(String token) {
            return "gxp$" + token + "$" + this.varCounter++;
        }

        private String getClassName(TemplateName name) {
            return name.toString();
        }

        private String getWriteMethodName(Schema schema) {
            String name = schema.getName();
            return "gxp$write" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }

        protected void writeExpression(SourcePosition pos, String expr) {
            this.formatLine(pos, "%s.append(%s);", GXP_OUT_VAR, expr);
        }

        protected void writeString(SourcePosition pos, String s) {
            int length = s.length();
            if (length != 0) {
                int curPos = 0;
                while (length - curPos > 65534) {
                    this.writeExpression(pos, OutputLanguage.JAVASCRIPT.toStringLiteral(s.substring(curPos, curPos + 65534)));
                    curPos += 65534;
                }
                this.writeExpression(pos, OutputLanguage.JAVASCRIPT.toStringLiteral(s.substring(curPos, length)));
            }
        }

        protected String getCalleeName(Callable callee) {
            return callee.acceptCallableVisitor(new CallableVisitor<String>(){

                @Override
                public String visitCallable(Callable callable) {
                    return TemplateWorker.this.getClassName(callable.getName());
                }

                @Override
                public String visitInstanceCallable(InstanceCallable callable) {
                    return TemplateWorker.this.instantiatedGxps.peek();
                }
            });
        }

        private List<String> getCallArguments(Callable callee, Map<String, Attribute> callerAttrs) {
            ArrayList<String> fParams = Lists.newArrayList();
            String calleeName = this.getCalleeName(callee);
            for (FormalParameter parameter : callee.getParameters()) {
                String defaultFetchString;
                String paramName = parameter.getPrimaryName();
                if ("this".equals(paramName)) continue;
                Attribute value = callerAttrs.get(paramName);
                String string = defaultFetchString = parameter.getType().getDefaultValue() == null ? calleeName + "." + JavaScriptCodeGenerator.getDefaultMethodName(parameter) + "()" : this.getJavaScriptExpression(parameter.getType().getDefaultValue());
                if (value == null) {
                    fParams.add(defaultFetchString);
                    continue;
                }
                if (value.getCondition() != null) {
                    String s = "(" + this.getJavaScriptExpression(value.getCondition()) + " ? " + this.getJavaScriptExpression(value.getValue()) + " : " + defaultFetchString + ")";
                    fParams.add(s);
                    continue;
                }
                fParams.add(this.getJavaScriptExpression(value.getValue()));
            }
            return fParams;
        }

        protected StatementVisitor getStatementVisitor() {
            return new StatementVisitor();
        }

        protected ToEscapableExpressionVisitor getToEscapableExpressionVisitor() {
            return new ToEscapableExpressionVisitor();
        }

        protected String getJavaScriptExpression(Expression value) {
            return value.acceptVisitor(this.toExpressionVisitor);
        }

        protected String getEscapedString(Expression value) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getJavaScriptExpression(value));
            sb.append(".");
            sb.append(this.getWriteMethodName(value.getSchema()));
            sb.append("(new goog.string.StringBuffer(), ");
            sb.append(GXP_CONTEXT_VAR);
            sb.append(").toString()");
            return sb.toString();
        }

        private String getEscapableExpression(Expression value) {
            return value.acceptVisitor(this.toEscapableExpressionVisitor);
        }

        private String toAnonymousClosure(Expression value) {
            StringBuilder sb = new StringBuilder();
            TemplateWorker subWorker = this.createSubWorker(sb);
            subWorker.toAnonymousClosureImpl(value);
            sb.append("})");
            return sb.toString();
        }

        private void toAnonymousClosureImpl(Expression value) {
            this.formatLine(value.getSourcePosition(), "new %s(function(%s) {", value.getSchema().getJavaScriptType(), GXP_SIG);
            value.acceptVisitor(this.statementVisitor);
            this.formatLine("return %s;", GXP_OUT_VAR);
        }

        private class ToExpressionVisitor
        extends DefaultingExpressionVisitor<String>
        implements CallVisitor<String> {
            private ContentFamilyVisitor<StringConstant, String> STRING_CONSTANT_VISITOR = new ContentFamilyVisitor<StringConstant, String>(){

                @Override
                public String visitCss(StringConstant value) {
                    return TemplateWorker.this.toAnonymousClosure(value);
                }

                @Override
                public String visitJavaScript(StringConstant value) {
                    return TemplateWorker.this.toAnonymousClosure(value);
                }

                @Override
                public String visitMarkup(StringConstant value) {
                    return TemplateWorker.this.toAnonymousClosure(value);
                }

                @Override
                public String visitPlaintext(StringConstant value) {
                    return OutputLanguage.JAVASCRIPT.toStringLiteral(value.evaluate());
                }
            };

            private ToExpressionVisitor() {
            }

            @Override
            public String defaultVisitExpression(Expression value) {
                throw new UnexpectedNodeException(value);
            }

            @Override
            public String visitAbbrExpression(AbbrExpression value) {
                return TemplateWorker.this.toAnonymousClosure(value);
            }

            @Override
            public String visitAttrBundleParam(AttrBundleParam bundle) {
                if (bundle.getIncludeAttrs().isEmpty() && bundle.getAttrs().isEmpty() && bundle.getSubBundles().size() == 1) {
                    return bundle.getSubBundles().get(0);
                }
                StringBuilder sb = new StringBuilder("new goog.gxp.base.GxpAttrBundle.Builder(");
                sb.append('\"');
                sb.append(TemplateWorker.this.getWriteMethodName(bundle.getSchema()));
                sb.append('\"');
                for (String string : bundle.getIncludeAttrs()) {
                    sb.append(", ");
                    sb.append(OutputLanguage.JAVASCRIPT.toStringLiteral(string));
                }
                sb.append(")");
                for (Map.Entry entry : bundle.getAttrs().entrySet()) {
                    AttributeValidator validator = (AttributeValidator)entry.getKey();
                    Expression condition = ((Attribute)entry.getValue()).getCondition();
                    Expression value = ((Attribute)entry.getValue()).getValue();
                    sb.append(".attr(");
                    sb.append(OutputLanguage.JAVASCRIPT.toStringLiteral(validator.getName()));
                    sb.append(", ");
                    sb.append(validator.isFlagSet(AttributeValidator.Flag.BOOLEAN) ? value.acceptVisitor(this) : TemplateWorker.this.toAnonymousClosure(value));
                    if (condition != null) {
                        sb.append(", ");
                        sb.append(condition.acceptVisitor(this));
                    }
                    sb.append(")");
                }
                for (String string : bundle.getSubBundles()) {
                    sb.append(".addBundle(");
                    sb.append(string);
                    sb.append(")");
                }
                sb.append(".build()");
                return sb.toString();
            }

            @Override
            public String visitBooleanConstant(BooleanConstant value) {
                return value.getValue().toString();
            }

            @Override
            public String visitConcatenation(Concatenation value) {
                return TemplateWorker.this.toAnonymousClosure(value);
            }

            @Override
            public String visitConditional(Conditional value) {
                return TemplateWorker.this.toAnonymousClosure(value);
            }

            @Override
            public String visitConstructedConstant(ConstructedConstant node) {
                StringBuilder sb = new StringBuilder();
                sb.append(TemplateWorker.this.getCalleeName(node.getCallee()));
                sb.append(".");
                sb.append(JavaScriptCodeGenerator.getConstructorMethodName(node.getParam()));
                sb.append("(\"");
                sb.append(node.getValue());
                sb.append("\")");
                return sb.toString();
            }

            @Override
            public String visitConvertibleToContent(ConvertibleToContent value) {
                return TemplateWorker.this.toAnonymousClosure(value);
            }

            @Override
            public String visitEscapeExpression(EscapeExpression value) {
                return value.getSubexpression().acceptVisitor(this);
            }

            @Override
            public String visitExampleExpression(ExampleExpression value) {
                return value.getSubexpression().acceptVisitor(this);
            }

            @Override
            public String visitExtractedMessage(ExtractedMessage msg) {
                return TemplateWorker.this.toAnonymousClosure(msg);
            }

            @Override
            public String visitLoopExpression(LoopExpression value) {
                return TemplateWorker.this.toAnonymousClosure(value);
            }

            @Override
            public String visitIsXmlExpression(IsXmlExpression ixe) {
                return "gxp_context.isUsingXmlSyntax()";
            }

            @Override
            public String visitNativeExpression(NativeExpression value) {
                return OutputLanguage.JAVASCRIPT.validateExpression(TemplateWorker.this.alertSink, value);
            }

            @Override
            public String visitObjectConstant(ObjectConstant node) {
                return OutputLanguage.JAVASCRIPT.toStringLiteral(node.getValue());
            }

            @Override
            public String visitStringConstant(StringConstant value) {
                if (value.getSchema() == null) {
                    throw new AssertionError();
                }
                return value.getSchema().getContentFamily().acceptVisitor(this.STRING_CONSTANT_VISITOR, value);
            }

            @Override
            public String visitCall(Call value) {
                return value.acceptCallVisitor(this);
            }

            @Override
            public String visitBoundCall(BoundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public String visitUnboundCall(UnboundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public String visitValidatedCall(final ValidatedCall call) {
                final Callable callee = call.getCallee();
                final StringBuilder sb = new StringBuilder();
                callee.acceptCallableVisitor(new CallableVisitor<Void>(){

                    @Override
                    public Void visitCallable(Callable callable) {
                        sb.append(callee.getName().toString());
                        sb.append(".getGxpClosure(");
                        sb.append(Join.join(", ", TemplateWorker.this.getCallArguments(callee, call.getAttributes())));
                        sb.append(")");
                        return null;
                    }

                    @Override
                    public Void visitInstanceCallable(InstanceCallable callable) {
                        sb.append(TemplateWorker.this.toAnonymousClosure(call));
                        return null;
                    }
                });
                return sb.toString();
            }
        }

        protected class ToEscapableExpressionVisitor
        extends DefaultingExpressionVisitor<String>
        implements CallVisitor<String> {
            protected ToEscapableExpressionVisitor() {
            }

            @Override
            public String defaultVisitExpression(Expression value) {
                throw new UnexpectedNodeException(value);
            }

            @Override
            public String visitAttrBundleReference(AttrBundleReference value) {
                return value.getName();
            }

            @Override
            public String visitEscapeExpression(EscapeExpression value) {
                StringBuilder sb = new StringBuilder();
                sb.append(TemplateWorker.this.getEscapableExpression(value.getSubexpression()));
                sb.append(".");
                sb.append(TemplateWorker.this.getWriteMethodName(value.getSchema()));
                sb.append("(new goog.string.StringBuffer(), ");
                sb.append(TemplateWorker.GXP_CONTEXT_VAR);
                sb.append(").toString()");
                return sb.toString();
            }

            @Override
            public String visitExtractedMessage(ExtractedMessage msg) {
                return TemplateWorker.this.getEscapedString(msg);
            }

            @Override
            public String visitNativeExpression(NativeExpression value) {
                StringBuilder sb = new StringBuilder();
                sb.append('(');
                sb.append(OutputLanguage.JAVASCRIPT.validateExpression(TemplateWorker.this.alertSink, value));
                sb.append(')');
                return sb.toString();
            }

            @Override
            public String visitCall(Call call) {
                return call.acceptCallVisitor(this);
            }

            @Override
            public String visitBoundCall(BoundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public String visitUnboundCall(UnboundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public String visitValidatedCall(ValidatedCall call) {
                StringBuilder sb = new StringBuilder(TemplateWorker.GXP_CONTEXT_VAR);
                sb.append(".getString(");
                sb.append(TemplateWorker.this.getJavaScriptExpression(call));
                sb.append(".");
                sb.append(TemplateWorker.this.getWriteMethodName(call.getSchema()));
                sb.append(")");
                return sb.toString();
            }
        }

        protected class StatementVisitor
        extends DefaultingExpressionVisitor<Void>
        implements CallVisitor<Void> {
            private final Pattern PARAM_PATTERN = Pattern.compile("%([1-9%])");

            protected StatementVisitor() {
            }

            @Override
            public Void defaultVisitExpression(Expression node) {
                throw new UnexpectedNodeException(node);
            }

            @Override
            public Void visitAbbrExpression(AbbrExpression abbr) {
                TemplateWorker.this.appendLine("(function() {");
                TemplateWorker.this.formatLine(abbr.getSourcePosition(), "var %s = %s;", new Object[]{OutputLanguage.JAVASCRIPT.validateName(TemplateWorker.this.alertSink, abbr, abbr.getName()), TemplateWorker.this.getJavaScriptExpression(abbr.getValue())});
                abbr.getContent().acceptVisitor(this);
                TemplateWorker.this.appendLine("})();");
                return null;
            }

            @Override
            public Void visitConcatenation(Concatenation value) {
                for (Expression subValue : value.getValues()) {
                    subValue.acceptVisitor(this);
                }
                return null;
            }

            @Override
            public Void visitConditional(Conditional value) {
                Iterator<Conditional.Clause> clauses = value.getClauses().iterator();
                if (clauses.hasNext()) {
                    this.appendIf("if (", clauses.next());
                    while (clauses.hasNext()) {
                        this.appendIf("} else if (", clauses.next());
                    }
                    Expression elseExpression = value.getElseExpression();
                    if (!elseExpression.alwaysEmpty()) {
                        TemplateWorker.this.appendLine("} else {");
                        elseExpression.acceptVisitor(this);
                    }
                } else {
                    throw new AssertionError((Object)"No clauses in Conditional!");
                }
                TemplateWorker.this.appendLine("}");
                return null;
            }

            private void appendIf(String prefix, Conditional.Clause clause) {
                Expression predicate = clause.getPredicate();
                TemplateWorker.this.appendLine(predicate.getSourcePosition(), prefix + TemplateWorker.this.getJavaScriptExpression(predicate) + ") {");
                clause.getExpression().acceptVisitor(this);
            }

            @Override
            public Void visitConvertibleToContent(ConvertibleToContent value) {
                value.getSubexpression().acceptVisitor(this);
                return null;
            }

            @Override
            public Void visitEscapeExpression(EscapeExpression value) {
                TemplateWorker.this.formatLine(value.getSourcePosition(), "%s.%s(%s);", new Object[]{TemplateWorker.this.getEscapableExpression(value.getSubexpression()), TemplateWorker.this.getWriteMethodName(value.getSchema()), GXP_SIG});
                return null;
            }

            @Override
            public Void visitExampleExpression(ExampleExpression value) {
                return value.getSubexpression().acceptVisitor(this);
            }

            @Override
            public Void visitExceptionExpression(ExceptionExpression value) {
                String excClass;
                switch (value.getKind()) {
                    case NOT_SUPPORTED_IN_SGML_MODE: {
                        excClass = "Error";
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unsupported ExceptionExpression.Kind: " + (Object)((Object)value.getKind())));
                    }
                }
                TemplateWorker.this.appendLine(value.getSourcePosition(), "throw new " + excClass + "(" + OutputLanguage.JAVASCRIPT.toStringLiteral(value.getMessage()) + ");");
                return null;
            }

            public String toLowerCamelCase(String s) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (String part : s.split("_")) {
                    part = part.toLowerCase();
                    if (first) {
                        first = false;
                    } else {
                        part = Character.toUpperCase(part.charAt(0)) + part.substring(1);
                    }
                    sb.append(part);
                }
                return sb.toString();
            }

            @Override
            public Void visitExtractedMessage(ExtractedMessage msg) {
                String paramVar = TemplateWorker.this.createVarName("params");
                if (!msg.getParameters().isEmpty()) {
                    StringBuilder sb = new StringBuilder("var ");
                    sb.append(paramVar);
                    sb.append(" = [");
                    Join.join(sb, ", ", Iterables.transform(msg.getParameters(), TemplateWorker.this.expressionToEscapedString));
                    sb.append("];");
                    TemplateWorker.this.appendLine(sb);
                }
                HashSet<Placeholder> placeholders = Sets.newHashSet();
                String msgVar = "MSG_EXTERNAL_" + msg.getTcMessage().getId();
                StringBuilder sb = new StringBuilder("var ");
                sb.append(msgVar);
                sb.append(" = goog.getMsg(\"");
                for (MessageFragment fragment : msg.getTcMessage()) {
                    if (fragment instanceof Placeholder) {
                        placeholders.add((Placeholder)fragment);
                        sb.append("{$");
                        sb.append(this.toLowerCamelCase(fragment.getPresentation()));
                        sb.append("}");
                        continue;
                    }
                    sb.append(CharEscapers.javascriptEscaper().escape(fragment.getPresentation()));
                }
                sb.append('\"');
                Iterator phIter = placeholders.iterator();
                if (phIter.hasNext()) {
                    sb.append(", {");
                    TemplateWorker.this.appendLine(msg.getSourcePosition(), sb);
                    sb = new StringBuilder();
                    while (phIter.hasNext()) {
                        Placeholder placeholder = (Placeholder)phIter.next();
                        sb.append(OutputLanguage.JAVASCRIPT.toStringLiteral(this.toLowerCamelCase(placeholder.getPresentation())));
                        sb.append(": ");
                        sb.append(this.evalPlaceholder(placeholder.getOriginal(), paramVar));
                        if (phIter.hasNext()) {
                            sb.append(",");
                        }
                        TemplateWorker.this.appendLine(msg.getSourcePosition(), sb);
                        sb = new StringBuilder();
                    }
                    sb.append("}");
                }
                sb.append(");");
                TemplateWorker.this.appendLine(msg.getSourcePosition(), sb);
                TemplateWorker.this.writeExpression(msg.getSourcePosition(), msgVar);
                return null;
            }

            private String evalPlaceholder(String original, String paramVar) {
                ArrayList<String> parts = Lists.newArrayList();
                Matcher m = this.PARAM_PATTERN.matcher(original);
                int cur = 0;
                while (m.find(cur)) {
                    parts.add(OutputLanguage.JAVASCRIPT.toStringLiteral(original.substring(cur, m.start())));
                    char ch = original.charAt(m.start() + 1);
                    if (m.group(1).equals("%")) {
                        parts.add("'%'");
                    } else {
                        parts.add(paramVar + "[" + (Integer.parseInt(m.group(1)) - 1) + "]");
                    }
                    cur = m.end();
                }
                parts.add(OutputLanguage.JAVASCRIPT.toStringLiteral(original.substring(cur, original.length())));
                return Join.join("+", parts);
            }

            @Override
            public Void visitLoopExpression(LoopExpression loop) {
                if (loop.getIterable() == null) {
                    if (loop.getIterator() != null && loop.getIterator().canEvaluateAs(OutputLanguage.JAVASCRIPT)) {
                        TemplateWorker.this.getJavaScriptExpression(loop.getIterator());
                    }
                    TemplateWorker.this.alertSink.add(new LoopRequiresIterableInJavaScriptError(loop));
                    return null;
                }
                String keyVar = loop.getKey() == null ? TemplateWorker.this.createVarName("key") : OutputLanguage.JAVASCRIPT.validateName(TemplateWorker.this.alertSink, loop, loop.getKey());
                TemplateWorker.this.formatLine(loop.getSourcePosition(), "goog.gxp.base.forEach(%s, function(%s, %s, gxp$isFirst) {", new Object[]{TemplateWorker.this.getJavaScriptExpression(loop.getIterable()), keyVar, OutputLanguage.JAVASCRIPT.validateName(TemplateWorker.this.alertSink, loop, loop.getVar())});
                if (!loop.getDelimiter().alwaysEmpty()) {
                    TemplateWorker.this.appendLine("if (!gxp$isFirst) {");
                    loop.getDelimiter().acceptVisitor(this);
                    TemplateWorker.this.appendLine("}");
                }
                loop.getSubexpression().acceptVisitor(this);
                TemplateWorker.this.appendLine("});");
                return null;
            }

            @Override
            public Void visitNativeExpression(NativeExpression value) {
                return null;
            }

            @Override
            public Void visitStringConstant(StringConstant value) {
                if (value.getSchema() == null) {
                    throw new AssertionError();
                }
                TemplateWorker.this.writeString(value.getSourcePosition(), value.evaluate());
                return null;
            }

            @Override
            public Void visitCall(Call value) {
                return value.acceptCallVisitor(this);
            }

            @Override
            public Void visitUnboundCall(UnboundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public Void visitBoundCall(BoundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public Void visitValidatedCall(final ValidatedCall call) {
                Callable callee = call.getCallee();
                final Map<String, Attribute> params = call.getAttributes();
                StringBuilder sb = new StringBuilder();
                boolean isInstance = callee.acceptCallableVisitor(new CallableVisitor<Boolean>(){

                    @Override
                    public Boolean visitCallable(Callable callable) {
                        return false;
                    }

                    @Override
                    public Boolean visitInstanceCallable(InstanceCallable callable) {
                        TemplateWorker.this.instantiatedGxps.push(TemplateWorker.this.createVarName("inst"));
                        Attribute thisAttr = (Attribute)params.get("this");
                        TemplateWorker.this.appendLine("{");
                        if (thisAttr != null) {
                            TemplateWorker.this.formatLine(call.getSourcePosition(), "var %s = %s;", new Object[]{TemplateWorker.this.instantiatedGxps.peek(), thisAttr.getValue().acceptVisitor(TemplateWorker.this.toExpressionVisitor)});
                        }
                        return true;
                    }
                });
                sb.append(TemplateWorker.this.getCalleeName(callee));
                sb.append(".write(");
                sb.append(GXP_SIG);
                for (String param : TemplateWorker.this.getCallArguments(callee, params)) {
                    sb.append(", ");
                    sb.append(param);
                }
                sb.append(");");
                TemplateWorker.this.appendLine(call.getSourcePosition(), sb);
                if (isInstance) {
                    TemplateWorker.this.instantiatedGxps.pop();
                    TemplateWorker.this.appendLine("}");
                }
                return null;
            }
        }
    }
}

