/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.stage.Window;
import org.apache.sis.gui.DataViewer;
import org.apache.sis.gui.internal.DataStoreOpener;
import org.apache.sis.gui.internal.ExceptionReporter;
import org.apache.sis.gui.internal.LogHandler;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.system.Threads;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.logging.Logging;

public final class BackgroundThreads
extends AtomicInteger
implements ThreadFactory {
    public static final boolean NO_INTERRUPT_DURING_IO = false;
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(new BackgroundThreads());

    private BackgroundThreads() {
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(Threads.SIS, r, "Application worker #" + this.incrementAndGet());
        t.setPriority(4);
        return t;
    }

    public static void execute(Runnable task) {
        if (Platform.isFxApplicationThread()) {
            EXECUTOR.execute(task);
        } else {
            task.run();
            CountDownLatch c = new CountDownLatch(1);
            Platform.runLater(c::countDown);
            try {
                c.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                BackgroundThreads.interrupted("execute", e);
            }
        }
    }

    public static <V> V runAndWaitDialog(Callable<V> task) {
        FutureTask<V> f = new FutureTask<V>(task);
        Platform.runLater(f);
        try {
            return f.get();
        }
        catch (ExecutionException e) {
            ExceptionReporter.show((Window)DataViewer.getCurrentStage(), null, null, (Throwable)e);
        }
        catch (InterruptedException e) {
            BackgroundThreads.interrupted("runAndWait", e);
        }
        return null;
    }

    public static <V> V runAndWait(Callable<V> task) throws Exception {
        FutureTask<V> f = new FutureTask<V>(task);
        Platform.runLater(f);
        try {
            return f.get();
        }
        catch (ExecutionException e) {
            throw Exceptions.unwrap((Exception)e);
        }
    }

    public static void stop() throws DataStoreException {
        EXECUTOR.shutdown();
        DataStoreOpener.closeAll();
        try {
            EXECUTOR.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            BackgroundThreads.interrupted("stop", e);
        }
    }

    private static void interrupted(String method, InterruptedException e) {
        Logging.unexpectedException((Logger)LogHandler.LOGGER, BackgroundThreads.class, (String)method, (Throwable)e);
    }
}

