/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.rest.common;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.core.provider.producer.ProducerMeta;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.foundation.common.utils.ReflectUtils;
import org.apache.servicecomb.provider.rest.common.RestSchema;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class RestProducers
implements BeanPostProcessor,
EnvironmentAware {
    private final List<ProducerMeta> producerMetaList = new ArrayList<ProducerMeta>();
    private final Class<? extends Annotation> restControllerCls = ReflectUtils.getClassByName((String)"org.springframework.web.bind.annotation.RestController");
    private Environment environment;

    public List<ProducerMeta> getProducerMetaList() {
        return this.producerMetaList;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.processProvider(beanName, bean);
        return bean;
    }

    protected void processProvider(String beanName, Object bean) {
        Class beanCls = BeanUtils.getImplClassFromBean((Object)bean);
        if (beanCls == null) {
            return;
        }
        RestSchema restSchema = beanCls.getAnnotation(RestSchema.class);
        if (restSchema != null) {
            ProducerMeta producerMeta = new ProducerMeta(restSchema.schemaId(), bean);
            producerMeta.setSchemaInterface(restSchema.schemaInterface());
            this.producerMetaList.add(producerMeta);
            return;
        }
        if (this.restControllerCls != null && ((Boolean)this.environment.getProperty("servicecomb.provider.rest.scanRestController", Boolean.TYPE, (Object)true)).booleanValue() && beanCls.getAnnotation(this.restControllerCls) != null) {
            ProducerMeta producerMeta = new ProducerMeta(beanCls.getName(), bean);
            this.producerMetaList.add(producerMeta);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

