/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.ViewBuilder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.SystemClock;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBatch;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.remoting.protocol.body.HARuntimeInfo;
import org.apache.rocketmq.store.AllocateMappedFileService;
import org.apache.rocketmq.store.AppendMessageResult;
import org.apache.rocketmq.store.CommitLog;
import org.apache.rocketmq.store.CommitLogDispatcher;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.MessageStoreStateMachine;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.QueryMessageResult;
import org.apache.rocketmq.store.RunningFlags;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.StoreCheckpoint;
import org.apache.rocketmq.store.StoreStatsService;
import org.apache.rocketmq.store.TransientStorePool;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.exception.ConsumeQueueException;
import org.apache.rocketmq.store.ha.HAService;
import org.apache.rocketmq.store.hook.PutMessageHook;
import org.apache.rocketmq.store.hook.SendMessageBackHook;
import org.apache.rocketmq.store.logfile.MappedFile;
import org.apache.rocketmq.store.metrics.StoreMetricsManager;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.ConsumeQueueStoreInterface;
import org.apache.rocketmq.store.stats.BrokerStatsManager;
import org.apache.rocketmq.store.timer.TimerMessageStore;
import org.apache.rocketmq.store.util.PerfCounter;
import org.rocksdb.RocksDBException;

public interface MessageStore {
    public boolean load();

    public void start() throws Exception;

    public void shutdown();

    public void destroy();

    default public CompletableFuture<PutMessageResult> asyncPutMessage(MessageExtBrokerInner msg) {
        return CompletableFuture.completedFuture(this.putMessage(msg));
    }

    default public CompletableFuture<PutMessageResult> asyncPutMessages(MessageExtBatch messageExtBatch) {
        return CompletableFuture.completedFuture(this.putMessages(messageExtBatch));
    }

    public PutMessageResult putMessage(MessageExtBrokerInner var1);

    public PutMessageResult putMessages(MessageExtBatch var1);

    public GetMessageResult getMessage(String var1, String var2, int var3, long var4, int var6, MessageFilter var7);

    public CompletableFuture<GetMessageResult> getMessageAsync(String var1, String var2, int var3, long var4, int var6, MessageFilter var7);

    public GetMessageResult getMessage(String var1, String var2, int var3, long var4, int var6, int var7, MessageFilter var8);

    public CompletableFuture<GetMessageResult> getMessageAsync(String var1, String var2, int var3, long var4, int var6, int var7, MessageFilter var8);

    public long getMaxOffsetInQueue(String var1, int var2) throws ConsumeQueueException;

    public long getMaxOffsetInQueue(String var1, int var2, boolean var3) throws ConsumeQueueException;

    public long getMinOffsetInQueue(String var1, int var2);

    public TimerMessageStore getTimerMessageStore();

    public void setTimerMessageStore(TimerMessageStore var1);

    public long getCommitLogOffsetInQueue(String var1, int var2, long var3);

    public long getOffsetInQueueByTime(String var1, int var2, long var3);

    public long getOffsetInQueueByTime(String var1, int var2, long var3, BoundaryType var5);

    public MessageExt lookMessageByOffset(long var1);

    public MessageExt lookMessageByOffset(long var1, int var3);

    public SelectMappedBufferResult selectOneMessageByOffset(long var1);

    public SelectMappedBufferResult selectOneMessageByOffset(long var1, int var3);

    public String getRunningDataInfo();

    public long getTimingMessageCount(String var1);

    public HashMap<String, String> getRuntimeInfo();

    public HARuntimeInfo getHARuntimeInfo();

    public long getMaxPhyOffset();

    public long getMinPhyOffset();

    public long getEarliestMessageTime(String var1, int var2);

    public long getEarliestMessageTime();

    public CompletableFuture<Long> getEarliestMessageTimeAsync(String var1, int var2);

    public long getMessageStoreTimeStamp(String var1, int var2, long var3);

    public CompletableFuture<Long> getMessageStoreTimeStampAsync(String var1, int var2, long var3);

    public long getMessageTotalInQueue(String var1, int var2);

    public SelectMappedBufferResult getCommitLogData(long var1);

    public List<SelectMappedBufferResult> getBulkCommitLogData(long var1, int var3);

    public boolean appendToCommitLog(long var1, byte[] var3, int var4, int var5);

    public void executeDeleteFilesManually();

    public QueryMessageResult queryMessage(String var1, String var2, int var3, long var4, long var6);

    public CompletableFuture<QueryMessageResult> queryMessageAsync(String var1, String var2, int var3, long var4, long var6);

    public void updateHaMasterAddress(String var1);

    public void updateMasterAddress(String var1);

    public long slaveFallBehindMuch();

    public long now();

    public int deleteTopics(Set<String> var1);

    public int cleanUnusedTopic(Set<String> var1);

    public void cleanExpiredConsumerQueue();

    @Deprecated
    public boolean checkInDiskByConsumeOffset(String var1, int var2, long var3);

    public boolean checkInMemByConsumeOffset(String var1, int var2, long var3, int var5);

    public boolean checkInStoreByConsumeOffset(String var1, int var2, long var3);

    public long dispatchBehindBytes();

    public long flushBehindBytes();

    public long dispatchBehindMilliseconds();

    public long flush();

    public long getFlushedWhere();

    public long getConfirmOffset();

    public void setConfirmOffset(long var1);

    public boolean isOSPageCacheBusy();

    public long lockTimeMills();

    public boolean isTransientStorePoolDeficient();

    public LinkedList<CommitLogDispatcher> getDispatcherList();

    public void addDispatcher(CommitLogDispatcher var1);

    public ConsumeQueueInterface getConsumeQueue(String var1, int var2);

    public ConsumeQueueInterface findConsumeQueue(String var1, int var2);

    public BrokerStatsManager getBrokerStatsManager();

    public void onCommitLogAppend(MessageExtBrokerInner var1, AppendMessageResult var2, MappedFile var3);

    public void onCommitLogDispatch(DispatchRequest var1, boolean var2, MappedFile var3, boolean var4, boolean var5) throws RocksDBException;

    public MessageStoreConfig getMessageStoreConfig();

    public StoreStatsService getStoreStatsService();

    public StoreCheckpoint getStoreCheckpoint();

    public SystemClock getSystemClock();

    public CommitLog getCommitLog();

    public RunningFlags getRunningFlags();

    public TransientStorePool getTransientStorePool();

    public HAService getHaService();

    public AllocateMappedFileService getAllocateMappedFileService();

    public void truncateDirtyLogicFiles(long var1) throws RocksDBException;

    public void unlockMappedFile(MappedFile var1);

    public PerfCounter.Ticks getPerfCounter();

    @Nonnull
    public ConsumeQueueStoreInterface getQueueStore();

    public boolean isSyncDiskFlush();

    public boolean isSyncMaster();

    public void assignOffset(MessageExtBrokerInner var1) throws RocksDBException;

    public void increaseOffset(MessageExtBrokerInner var1, short var2);

    public MessageStore getMasterStoreInProcess();

    public void setMasterStoreInProcess(MessageStore var1);

    public boolean getData(long var1, int var3, ByteBuffer var4);

    public void setAliveReplicaNumInGroup(int var1);

    public int getAliveReplicaNumInGroup();

    public void wakeupHAClient();

    public long getMasterFlushedOffset();

    public long getBrokerInitMaxOffset();

    public void setMasterFlushedOffset(long var1);

    public void setBrokerInitMaxOffset(long var1);

    public byte[] calcDeltaChecksum(long var1, long var3);

    public boolean truncateFiles(long var1) throws RocksDBException;

    public boolean isOffsetAligned(long var1);

    public List<PutMessageHook> getPutMessageHookList();

    public void setSendMessageBackHook(SendMessageBackHook var1);

    public SendMessageBackHook getSendMessageBackHook();

    public long getLastFileFromOffset();

    public boolean getLastMappedFile(long var1);

    public void setPhysicalOffset(long var1);

    public boolean isMappedFilesEmpty();

    public long getStateMachineVersion();

    public StoreMetricsManager getStoreMetricsManager();

    public DispatchRequest checkMessageAndReturnSize(ByteBuffer var1, boolean var2, boolean var3, boolean var4);

    public int remainTransientStoreBufferNumbs();

    public long remainHowManyDataToCommit();

    public long remainHowManyDataToFlush();

    public boolean isShutdown();

    public long estimateMessageCount(String var1, int var2, long var3, long var5, MessageFilter var7);

    public List<Pair<InstrumentSelector, ViewBuilder>> getMetricsView();

    public void initMetrics(Meter var1, Supplier<AttributesBuilder> var2);

    public void recoverTopicQueueTable();

    public void notifyMessageArriveIfNecessary(DispatchRequest var1);

    public MessageStoreStateMachine getStateMachine();
}

