/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.encryption;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;

public class EncryptionHelper {
    static boolean isValidBase64(String encrypted) {
        return encrypted.matches("^([\\w\\d+/]{4})*([\\w\\d+/]{2}==|[\\w\\d+/]{3}=)?$");
    }

    static byte[] readFromCipherStream(byte[] unencryptedBytes, Cipher cipher) throws IOException {
        return EncryptionHelper.readFromCipherStream(unencryptedBytes, 0, unencryptedBytes.length, cipher);
    }

    static byte[] readFromCipherStream(byte[] unencryptedBytes, int offset, int length, Cipher cipher) throws IOException {
        byte[] encryptedBytes;
        try (CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(unencryptedBytes, offset, length), cipher);){
            int read;
            byte[] buf = new byte[512];
            int pos = 0;
            while ((read = cipherInputStream.read(buf, pos, buf.length - pos)) != -1) {
                if ((pos += read) != buf.length) continue;
                byte[] tmp = buf;
                buf = new byte[buf.length + 512];
                System.arraycopy(tmp, 0, buf, 0, tmp.length);
            }
            encryptedBytes = new byte[pos];
            System.arraycopy(buf, 0, encryptedBytes, 0, pos);
        }
        return encryptedBytes;
    }
}

