/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.operations;

import com.hazelcast.client.impl.ClientDataSerializerHook;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import java.io.IOException;
import java.util.UUID;

public final class OperationFactoryWrapper
implements OperationFactory {
    private OperationFactory opFactory;
    private UUID uuid;

    public OperationFactoryWrapper() {
    }

    public OperationFactoryWrapper(OperationFactory opFactory, UUID uuid) {
        this.opFactory = opFactory;
        this.uuid = uuid;
    }

    @Override
    public Operation createOperation() {
        Operation op = this.opFactory.createOperation();
        op.setCallerUuid(this.uuid);
        return op;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.uuid);
        out.writeObject(this.opFactory);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.uuid = UUIDSerializationUtil.readUUID(in);
        this.opFactory = (OperationFactory)in.readObject();
    }

    public OperationFactory getOperationFactory() {
        return this.opFactory;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public int getFactoryId() {
        return ClientDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    public String toString() {
        return "OperationFactoryWrapper{opFactory=" + this.opFactory + ", uuid='" + this.uuid + "'}";
    }
}

