/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OrderedProperties
extends Properties {
    private final Map<String, String> textBeforeMap = new HashMap<String, String>();
    private final Set<Object> orderedKeys = new LinkedHashSet<Object>();

    @Override
    public synchronized Object put(Object key, Object value) {
        this.orderedKeys.add(key);
        return super.put(key, value);
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(this.orderedKeys.stream().filter(this::containsKey).collect(Collectors.toList()));
    }

    @Override
    public synchronized Set<Map.Entry<Object, Object>> entrySet() {
        return this.orderedKeys.stream().map(k -> new AbstractMap.SimpleImmutableEntry<Object, Object>(k, this.get(k))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public synchronized Object setProperty(String key, String value, String textBefore) {
        this.textBeforeMap.put(key, textBefore);
        return this.setProperty(key, value);
    }

    @Override
    public synchronized void store(OutputStream out, String comments) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.store(byteArrayOutputStream, comments);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), "8859_1"));
             BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                String textBefore;
                int equalsIndex = line.indexOf(61);
                if (equalsIndex != -1 && StringUtils.isNotBlank((CharSequence)(textBefore = this.textBeforeMap.get(line.substring(0, equalsIndex))))) {
                    bufferedWriter.write(textBefore);
                    bufferedWriter.newLine();
                }
                bufferedWriter.write(line);
                bufferedWriter.newLine();
            }
        }
    }
}

