/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.provider.extension;

import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.extension.BundleCoordinate;

public class StandardBundleCoordinate
implements BundleCoordinate {
    private final String bucketId;
    private final String groupId;
    private final String artifactId;

    private StandardBundleCoordinate(Builder builder) {
        this.bucketId = builder.bucketId;
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        Validate.notBlank((CharSequence)this.bucketId, (String)"Bucket Id is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.groupId, (String)"Group Id is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.artifactId, (String)"Artifact Id is required", (Object[])new Object[0]);
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardBundleCoordinate that = (StandardBundleCoordinate)o;
        return this.bucketId.equals(that.bucketId) && this.groupId.equals(that.groupId) && this.artifactId.equals(that.artifactId);
    }

    public int hashCode() {
        return Objects.hash(this.bucketId, this.groupId, this.artifactId);
    }

    public static class Builder {
        private String bucketId;
        private String groupId;
        private String artifactId;

        public Builder bucketId(String bucketId) {
            this.bucketId = bucketId;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public StandardBundleCoordinate build() {
            return new StandardBundleCoordinate(this);
        }
    }
}

