/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class ActivationFile
implements Serializable,
InputLocationTracker {
    final String missing;
    final String exists;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected ActivationFile(Builder builder) {
        String string = builder.missing != null ? builder.missing : (this.missing = builder.base != null ? builder.base.missing : null);
        this.exists = builder.exists != null ? builder.exists : (builder.base != null ? builder.base.exists : null);
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    public String getMissing() {
        return this.missing;
    }

    public String getExists() {
        return this.exists;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations.get(key);
    }

    public Set<Object> getLocationKeys() {
        return this.locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return this.locations.keySet().stream();
    }

    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return ActivationFile.newBuilder(this);
    }

    @Nonnull
    public ActivationFile withMissing(String missing) {
        return ActivationFile.newBuilder(this, true).missing(missing).build();
    }

    @Nonnull
    public ActivationFile withExists(String exists) {
        return ActivationFile.newBuilder(this, true).exists(exists).build();
    }

    @Nonnull
    public static ActivationFile newInstance() {
        return ActivationFile.newInstance(true);
    }

    @Nonnull
    public static ActivationFile newInstance(boolean withDefaults) {
        return ActivationFile.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return ActivationFile.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(ActivationFile from) {
        return ActivationFile.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(ActivationFile from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        ActivationFile base;
        String missing;
        String exists;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(ActivationFile base, boolean forceCopy) {
            if (forceCopy) {
                this.missing = base.missing;
                this.exists = base.exists;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder missing(String missing) {
            this.missing = missing;
            return this;
        }

        @Nonnull
        public Builder exists(String exists) {
            this.exists = exists;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public ActivationFile build() {
            if (!(this.base == null || this.missing != null && this.missing != this.base.missing || this.exists != null && this.exists != this.base.exists)) {
                return this.base;
            }
            return new ActivationFile(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map oldlocs;
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Map.of();
            Map<Object, Object> map = oldlocs = this.base != null ? this.base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }
}

