/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.jpms;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.lib.strings.Strings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class JPMSAnnotations
implements AnalyzerPlugin {
    @Override
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        HashSet<Descriptors.PackageRef> processed = new HashSet<Descriptors.PackageRef>();
        for (Clazz c : analyzer.getClassspace().values()) {
            Descriptors.PackageRef packageRef = c.getClassName().getPackageRef();
            if (processed.contains(packageRef)) continue;
            processed.add(packageRef);
            Clazz packageInfo = analyzer.getPackageInfo(packageRef);
            if (packageInfo == null) continue;
            packageInfo.annotations("aQute/bnd/annotation/jpms/Open").forEach(annotation -> {
                String modules = "";
                if (annotation.get("value") != null) {
                    modules = Arrays.stream((Object[])annotation.get("value")).map(Object::toString).collect(Collectors.joining(","));
                }
                analyzer.getContained().get(packageRef).put("-internal-open-to-modules:", modules);
            });
            packageInfo.annotations("org/osgi/annotation/bundle/Export").forEach(export -> {
                List modules = packageInfo.annotations("aQute/bnd/annotation/jpms/ExportTo").map(annotation -> annotation.get("value")).map(Object[].class::cast).flatMap(Arrays::stream).map(Object::toString).collect(Collectors.toList());
                if (!modules.isEmpty()) {
                    analyzer.getContained().get(packageRef).put("-internal-export-to-modules:", Strings.join(modules));
                }
            });
        }
        return false;
    }
}

