/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import org.apache.james.core.Disconnector;
import org.apache.james.core.Username;

public interface DisconnectorNotifier {
    public void disconnect(Request var1);

    public static class InVMDisconnectorNotifier
    implements DisconnectorNotifier {
        private final Disconnector disconnector;

        @Inject
        public InVMDisconnectorNotifier(Disconnector disconnector) {
            this.disconnector = disconnector;
        }

        @Override
        public void disconnect(Request request) {
            Request request2 = request;
            Objects.requireNonNull(request2);
            Request request3 = request2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MultipleUserRequest.class, AllUsersRequest.class}, (Object)request3, n)) {
                case 0: {
                    MultipleUserRequest multipleUserRequest = (MultipleUserRequest)request3;
                    this.disconnector.disconnect(multipleUserRequest::contains);
                    break;
                }
                case 1: {
                    AllUsersRequest allUsersRequest = (AllUsersRequest)request3;
                    this.disconnector.disconnect(username -> true);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(request));
                }
            }
        }
    }

    public record AllUsersRequest() implements Request
    {
        public static AllUsersRequest ALL_USERS_REQUEST = new AllUsersRequest();
    }

    public record MultipleUserRequest(Set<Username> usernameList) implements Request
    {
        public MultipleUserRequest {
            Preconditions.checkArgument((usernameList != null && !usernameList.isEmpty() ? 1 : 0) != 0, (Object)"usernameList should not be empty");
        }

        public static MultipleUserRequest of(Username username) {
            return new MultipleUserRequest(Set.of(username));
        }

        public static MultipleUserRequest of(Set<Username> usernameList) {
            return new MultipleUserRequest(usernameList);
        }

        public boolean contains(Username username) {
            return this.usernameList.contains(username);
        }
    }

    public static sealed interface Request
    permits MultipleUserRequest, AllUsersRequest {
    }
}

