/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mime4j;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.james.jmap.mail.Email;
import org.apache.james.jmap.mime4j.MaximalBodyDescriptor;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.field.DefaultFieldParser;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.util.MimeUtil;

public class JamesBodyDescriptorBuilder
implements BodyDescriptorBuilder {
    private static final String CONTENT_TYPE = "Content-Type".toLowerCase(Locale.US);
    private static final String SUB_TYPE_EMAIL = "rfc822";
    private static final String MEDIA_TYPE_TEXT = "text";
    private static final String MEDIA_TYPE_MESSAGE = "message";
    private static final String EMAIL_MESSAGE_MIME_TYPE = "message/rfc822";
    private static final String DEFAULT_SUB_TYPE = "plain";
    private static final String DEFAULT_MEDIA_TYPE = "text";
    private static final String DEFAULT_MIME_TYPE = "text/plain";
    private final String parentMimeType;
    private final DecodeMonitor monitor;
    private final FieldParser<? extends ParsedField> fieldParser;
    private final Map<String, ParsedField> fields;
    private Charset defaultCharset = Email.defaultCharset();

    public JamesBodyDescriptorBuilder() {
        this(null);
    }

    public JamesBodyDescriptorBuilder(String parentMimeType) {
        this(parentMimeType, null, null);
    }

    public JamesBodyDescriptorBuilder(String parentMimeType, FieldParser<? extends ParsedField> fieldParser, DecodeMonitor monitor) {
        this.parentMimeType = parentMimeType;
        this.fieldParser = fieldParser != null ? fieldParser : DefaultFieldParser.getParser();
        this.monitor = monitor != null ? monitor : DecodeMonitor.SILENT;
        this.fields = new HashMap<String, ParsedField>();
    }

    public void setDefaultCharset(Charset charset) {
        this.defaultCharset = charset;
    }

    public void reset() {
        this.fields.clear();
    }

    public Field addField(RawField rawfield) throws MimeException {
        ParsedField field = this.fieldParser.parse((Field)rawfield, this.monitor);
        String name = field.getNameLowerCase();
        if (field.bodyDescriptionField() && !this.fields.containsKey(name)) {
            this.fields.put(name, field);
        }
        return field;
    }

    public BodyDescriptor build() {
        String actualMimeType = null;
        String actualMediaType = null;
        String actualSubType = null;
        String actualCharset = null;
        String actualBoundary = null;
        ContentTypeField contentTypeField = (ContentTypeField)this.fields.get(CONTENT_TYPE);
        if (contentTypeField != null) {
            boolean multipart;
            actualMimeType = contentTypeField.getMimeType();
            actualMediaType = contentTypeField.getMediaType();
            actualSubType = contentTypeField.getSubType();
            actualCharset = contentTypeField.getCharset();
            actualBoundary = contentTypeField.getBoundary();
            boolean bl = multipart = actualMediaType != null && actualMediaType.equalsIgnoreCase("multipart");
            if (multipart && actualBoundary == null) {
                actualMimeType = null;
                actualMediaType = null;
                actualSubType = null;
            }
        }
        if (actualMimeType == null) {
            if (MimeUtil.isSameMimeType((String)"multipart/digest", (String)this.parentMimeType)) {
                actualMimeType = EMAIL_MESSAGE_MIME_TYPE;
                actualMediaType = MEDIA_TYPE_MESSAGE;
                actualSubType = SUB_TYPE_EMAIL;
            } else {
                actualMimeType = DEFAULT_MIME_TYPE;
                actualMediaType = "text";
                actualSubType = DEFAULT_SUB_TYPE;
            }
        }
        if (actualCharset == null && "text".equals(actualMediaType)) {
            actualCharset = this.defaultCharset.name();
        }
        if (!MimeUtil.isMultipart((String)actualMimeType)) {
            actualBoundary = null;
        }
        return new MaximalBodyDescriptor(actualMimeType, actualMediaType, actualSubType, actualBoundary, actualCharset, this.fields);
    }

    public BodyDescriptorBuilder newChild() {
        ContentTypeField contentTypeField = (ContentTypeField)this.fields.get(CONTENT_TYPE);
        String actualMimeType = contentTypeField != null ? contentTypeField.getMimeType() : (MimeUtil.isSameMimeType((String)"multipart/digest", (String)this.parentMimeType) ? EMAIL_MESSAGE_MIME_TYPE : DEFAULT_MIME_TYPE);
        return new JamesBodyDescriptorBuilder(actualMimeType, this.fieldParser, this.monitor);
    }
}

