/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.server.core.MailImpl;
import org.apache.james.util.AuditTrail;
import org.apache.james.util.MemoizedSupplier;
import org.apache.mailet.DsnParameters;
import org.apache.mailet.LoopPrevention;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.ProcessingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipientRewriteTableProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecipientRewriteTableProcessor.class);
    private static final boolean REWRITE_SENDER_UPON_FORWARD = true;
    private static final boolean FORWARD_AUTOMATED_EMAILS = true;
    private final RecipientRewriteTable virtualTableStore;
    private final MailetContext mailetContext;
    private final Supplier<Domain> defaultDomainSupplier;
    private final ProcessingState errorProcessor;
    private final boolean rewriteSenderUponForward;
    private final boolean forwardAutoSubmittedEmails;
    private final EnumSet<Mapping.Type> mappingTypes;

    public RecipientRewriteTableProcessor(RecipientRewriteTable virtualTableStore, DomainList domainList, MailetContext mailetContext, ProcessingState errorProcessor, boolean rewriteSenderUponForward, boolean forwardAutoSubmittedEmails) {
        this.virtualTableStore = virtualTableStore;
        this.mailetContext = mailetContext;
        this.defaultDomainSupplier = MemoizedSupplier.of((Supplier)Throwing.supplier(() -> this.getDefaultDomain(domainList)).sneakyThrow());
        this.errorProcessor = errorProcessor;
        this.rewriteSenderUponForward = rewriteSenderUponForward;
        this.forwardAutoSubmittedEmails = forwardAutoSubmittedEmails;
        if (rewriteSenderUponForward) {
            EnumSet<Mapping.Type> types = EnumSet.allOf(Mapping.Type.class);
            types.remove(Mapping.Type.Forward);
            this.mappingTypes = types;
        } else {
            this.mappingTypes = EnumSet.allOf(Mapping.Type.class);
        }
    }

    public RecipientRewriteTableProcessor(RecipientRewriteTable virtualTableStore, DomainList domainList, MailetContext mailetContext) {
        this(virtualTableStore, domainList, mailetContext, new ProcessingState("error"), false, false);
    }

    private Domain getDefaultDomain(DomainList domainList) throws MessagingException {
        try {
            return domainList.getDefaultDomain();
        }
        catch (DomainListException e) {
            throw new MessagingException("Unable to access DomainList", (Exception)((Object)e));
        }
    }

    public void processMail(Mail mail) throws MessagingException {
        ImmutableList recipientsBeforeRecipientsRewrite = ImmutableList.copyOf((Collection)mail.getRecipients());
        List<Decision> decisions = this.executeRrtFor(mail);
        this.applyDecisionsOnMailRecipients(mail, decisions);
        this.applyDecisionOnDSNParameters(mail, decisions);
        Collection recipientsAfterRecipientsRewrite = mail.getRecipients();
        AuditTrail.entry().protocol("mailetcontainer").action("RecipientRewrite").parameters((Supplier)Throwing.supplier(() -> RecipientRewriteTableProcessor.lambda$processMail$1(mail, (Collection)recipientsBeforeRecipientsRewrite, recipientsAfterRecipientsRewrite))).log("Recipients rewritten.");
        this.processForwards(mail);
    }

    public void processForwards(Mail mail) throws MessagingException {
        if (!this.forwardAutoSubmittedEmails && RecipientRewriteTableProcessor.isAutoSubmitted(mail)) {
            return;
        }
        if (this.rewriteSenderUponForward) {
            mail.getRecipients().stream().flatMap(Throwing.function(mailAddress -> this.processForward(mail, (MailAddress)mailAddress))).forEach(Throwing.consumer(decision -> decision.apply(mail)));
        }
    }

    private static boolean isAutoSubmitted(Mail mail) throws MessagingException {
        return Optional.ofNullable(mail.getMessage().getHeader("Auto-Submitted")).map(ImmutableList::copyOf).orElse(ImmutableList.of()).stream().anyMatch(value -> value.startsWith("auto-replied"));
    }

    private Stream<ForwardDecision> processForward(Mail mail, MailAddress recipient) throws RecipientRewriteTableException {
        ImmutableSet<Mapping> forwards = this.getForwards(recipient);
        if (forwards.isEmpty()) {
            return Stream.of(new ForwardDecision[0]);
        }
        return this.forwardDecision(mail, forwards, recipient);
    }

    private Stream<ForwardDecision> forwardDecision(Mail mail, ImmutableSet<Mapping> forwards, MailAddress originalRecipient) {
        boolean emailIsDropped;
        boolean localCopy;
        LoopPrevention.RecordedRecipients recordedRecipients = LoopPrevention.RecordedRecipients.fromMail((Mail)mail);
        List forwardedRecipients = (List)forwards.stream().flatMap(mapping -> mapping.asMailAddress().stream()).collect(ImmutableList.toImmutableList());
        Set newRecipients = recordedRecipients.nonRecordedRecipients((Collection)forwardedRecipients);
        Sets.SetView forwardRecipients = Sets.difference((Set)newRecipients, (Set)ImmutableSet.of((Object)originalRecipient));
        if (recordedRecipients.getRecipients().contains(originalRecipient)) {
            return Stream.of(new ForwardDecision[0]);
        }
        ImmutableList.Builder result = ImmutableList.builder();
        if (!forwardRecipients.isEmpty()) {
            result.add((Object)ForwardDecision.sendACopy(this.mailetContext, originalRecipient, (Set<MailAddress>)forwardRecipients));
        }
        if (!(localCopy = newRecipients.contains(originalRecipient))) {
            result.add((Object)ForwardDecision.removeRecipient(originalRecipient));
        }
        boolean bl = emailIsDropped = !forwardedRecipients.isEmpty() && forwardRecipients.isEmpty() && !localCopy;
        if (emailIsDropped) {
            result.add((Object)ForwardDecision.recordLoop(this.mailetContext, originalRecipient, this.errorProcessor));
        }
        return result.build().stream();
    }

    private ImmutableSet<Mapping> getForwards(MailAddress recipient) throws RecipientRewriteTableException {
        return RecipientRewriteTableProcessor.getSource(recipient).map(Throwing.function(source -> (ImmutableSet)this.virtualTableStore.getStoredMappings(source).select(Mapping.Type.Forward).asStream().collect(ImmutableSet.toImmutableSet())).sneakyThrow()).orElse(ImmutableSet.of());
    }

    private static Optional<MappingSource> getSource(MailAddress recipient) {
        try {
            return Optional.of(MappingSource.fromMailAddress((MailAddress)recipient));
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Valid mail address {} could not be converted into a username. Assuming empty mappigns.", (Object)recipient.asString(), (Object)e);
            return Optional.empty();
        }
    }

    private void applyDecisionOnDSNParameters(Mail mail, List<Decision> decisions) {
        mail.dsnParameters().map(dsnParameters -> decisions.stream().reduce(dsnParameters, (parameters, decision) -> decision.applyOnDsnParameters((DsnParameters)parameters), (a, b) -> {
            throw new NotImplementedException("No combiner needed as we are not in a multi-threaded environment");
        })).ifPresent(arg_0 -> ((Mail)mail).setDsnParameters(arg_0));
    }

    private void applyDecisionsOnMailRecipients(Mail mail, List<Decision> decisions) throws MessagingException {
        RrtExecutionResult executionResults = decisions.stream().map(Decision::executionResult).reduce(RrtExecutionResult.empty(), RrtExecutionResult::merge);
        if (!executionResults.recipientWithError.isEmpty()) {
            MailImpl newMail = MailImpl.builder().name(mail.getName()).sender(mail.getMaybeSender()).addRecipients(executionResults.recipientWithError).mimeMessage(mail.getMessage()).state(this.errorProcessor.getValue()).build();
            this.mailetContext.sendMail((Mail)newMail);
            LifecycleUtil.dispose((Object)newMail);
        }
        if (executionResults.newRecipients.isEmpty()) {
            mail.setState("ghost");
        }
        mail.setRecipients(executionResults.newRecipients);
    }

    private List<Decision> executeRrtFor(Mail mail) {
        Function<MailAddress, Decision> convertToMappingData = recipient -> {
            Preconditions.checkNotNull((Object)recipient);
            return this.executeRrtForRecipient(mail, (MailAddress)recipient);
        };
        return (List)mail.getRecipients().stream().map(convertToMappingData).collect(ImmutableList.toImmutableList());
    }

    private Decision executeRrtForRecipient(Mail mail, MailAddress recipient) {
        try {
            Mappings mappings = this.virtualTableStore.getResolvedMappings(recipient.getLocalPart(), recipient.getDomain(), this.mappingTypes);
            if (mappings != null && !mappings.isEmpty()) {
                List<MailAddress> newMailAddresses = this.handleMappings(mappings, mail, recipient);
                return new Decision(recipient, RrtExecutionResult.success(newMailAddresses));
            }
            return new Decision(recipient, RrtExecutionResult.success(recipient));
        }
        catch (RecipientRewriteTable.ErrorMappingException e) {
            LOGGER.warn("Could not rewrite recipient {}", (Object)recipient, (Object)e);
            return new Decision(recipient, RrtExecutionResult.error(recipient));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    List<MailAddress> handleMappings(Mappings mappings, Mail mail, MailAddress recipient) throws MessagingException {
        boolean isLocal = true;
        ImmutableMap<Boolean, List<MailAddress>> mailAddressSplit = this.splitRemoteMailAddresses(mappings);
        this.forwardToRemoteAddress(mail, recipient, (Collection)mailAddressSplit.get(!isLocal));
        return (List)mailAddressSplit.get(isLocal);
    }

    private ImmutableMap<Boolean, List<MailAddress>> splitRemoteMailAddresses(Mappings mappings) {
        return (ImmutableMap)this.mailAddressesPerDomain(mappings).collect(Collectors.partitioningBy(entry -> this.mailetContext.isLocalServer((Domain)entry.getKey()))).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (List)((List)entry.getValue()).stream().flatMap(domainEntry -> ((Collection)domainEntry.getValue()).stream()).collect(ImmutableList.toImmutableList())));
    }

    private Stream<Map.Entry<Domain, Collection<MailAddress>>> mailAddressesPerDomain(Mappings mappings) {
        return ((ImmutableListMultimap)mappings.asStream().map(mapping -> mapping.appendDomainIfNone(this.defaultDomainSupplier)).map(Mapping::asMailAddress).flatMap(Optional::stream).collect(ImmutableListMultimap.toImmutableListMultimap(MailAddress::getDomain, Function.identity()))).asMap().entrySet().stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardToRemoteAddress(Mail mail, MailAddress recipient, Collection<MailAddress> remoteRecipients) throws MessagingException {
        if (!remoteRecipients.isEmpty()) {
            Mail duplicate = null;
            try {
                duplicate = mail.duplicate();
                duplicate.setRecipients((Collection)ImmutableList.copyOf(remoteRecipients));
                this.mailetContext.sendMail(duplicate);
                LOGGER.info("Mail for {} forwarded to {}", (Object)recipient, remoteRecipients);
            }
            finally {
                LifecycleUtil.dispose((Object)duplicate);
            }
        }
    }

    private static /* synthetic */ Map lambda$processMail$1(Mail mail, Collection recipientsBeforeRecipientsRewrite, Collection recipientsAfterRecipientsRewrite) throws Throwable {
        return ImmutableMap.of((Object)"mailId", (Object)mail.getName(), (Object)"mimeMessageId", (Object)Optional.ofNullable(mail.getMessage()).map(Throwing.function(MimeMessage::getMessageID)).orElse(""), (Object)"sender", (Object)mail.getMaybeSender().asString(), (Object)"recipientsBeforeRewrite", (Object)StringUtils.join((Object[])new Collection[]{recipientsBeforeRecipientsRewrite}), (Object)"recipientsAfterRewrite", (Object)StringUtils.join((Object[])new Collection[]{recipientsAfterRecipientsRewrite}));
    }

    static interface ForwardDecision {
        public static ForwardDecision removeRecipient(MailAddress recipient) {
            return mail -> mail.setRecipients((Collection)mail.getRecipients().stream().filter(r -> !r.equals((Object)recipient)).collect(ImmutableList.toImmutableList()));
        }

        public static ForwardDecision sendACopy(MailetContext context, MailAddress originalRecipient, Set<MailAddress> newRecipients) {
            return mail -> {
                MailImpl copy = MailImpl.duplicate((Mail)mail);
                LoopPrevention.RecordedRecipients recordedRecipients = LoopPrevention.RecordedRecipients.fromMail((Mail)mail);
                try {
                    copy.setSender(originalRecipient);
                    copy.setRecipients((Collection)newRecipients);
                    recordedRecipients.merge(new MailAddress[]{originalRecipient}).recordOn((Mail)copy);
                    context.sendMail((Mail)copy);
                    ForwardDecision.recordInAuditTrail(mail, copy, originalRecipient);
                }
                finally {
                    LifecycleUtil.dispose((Object)copy);
                }
            };
        }

        public static ForwardDecision recordLoop(MailetContext context, MailAddress originalRecipient, ProcessingState errorProcessor) {
            return mail -> {
                MailImpl copy = MailImpl.duplicate((Mail)mail);
                try {
                    copy.setRecipients((Collection)ImmutableList.of((Object)originalRecipient));
                    copy.setState(errorProcessor.getValue());
                    context.sendMail((Mail)copy, errorProcessor.getValue());
                }
                finally {
                    LifecycleUtil.dispose((Object)copy);
                }
            };
        }

        private static void recordInAuditTrail(Mail mail, MailImpl copy, MailAddress originalRecipient) {
            AuditTrail.entry().protocol("mailetcontainer").action("RecipientRewrite").parameters((Supplier)Throwing.supplier(() -> ImmutableMap.of((Object)"mailId", (Object)mail.getName(), (Object)"mimeMessageId", (Object)Optional.ofNullable(mail.getMessage()).map(Throwing.function(MimeMessage::getMessageID)).orElse(""), (Object)"sender", (Object)mail.getMaybeSender().asString(), (Object)"forwardedMailId", (Object)copy.getName(), (Object)"forwardedMailSender", (Object)originalRecipient.asString(), (Object)"forwardedMailRecipient", (Object)StringUtils.join((Object[])new Collection[]{copy.getRecipients()})))).log("Mail forwarded.");
        }

        public void apply(Mail var1) throws Exception;
    }

    private static class RrtExecutionResult {
        private final ImmutableSet<MailAddress> newRecipients;
        private final ImmutableSet<MailAddress> recipientWithError;

        private static RrtExecutionResult empty() {
            return new RrtExecutionResult((ImmutableSet<MailAddress>)ImmutableSet.of(), (ImmutableSet<MailAddress>)ImmutableSet.of());
        }

        private static RrtExecutionResult error(MailAddress mailAddress) {
            return new RrtExecutionResult((ImmutableSet<MailAddress>)ImmutableSet.of(), (ImmutableSet<MailAddress>)ImmutableSet.of((Object)mailAddress));
        }

        private static RrtExecutionResult success(MailAddress mailAddress) {
            return new RrtExecutionResult((ImmutableSet<MailAddress>)ImmutableSet.of((Object)mailAddress), (ImmutableSet<MailAddress>)ImmutableSet.of());
        }

        private static RrtExecutionResult success(List<MailAddress> mailAddresses) {
            return new RrtExecutionResult((ImmutableSet<MailAddress>)ImmutableSet.copyOf(mailAddresses), (ImmutableSet<MailAddress>)ImmutableSet.of());
        }

        private static RrtExecutionResult merge(RrtExecutionResult result1, RrtExecutionResult result2) {
            return new RrtExecutionResult((ImmutableSet<MailAddress>)ImmutableSet.builder().addAll(result1.getNewRecipients()).addAll(result2.getNewRecipients()).build(), (ImmutableSet<MailAddress>)ImmutableSet.builder().addAll(result1.getRecipientWithError()).addAll(result2.getRecipientWithError()).build());
        }

        public RrtExecutionResult(ImmutableSet<MailAddress> newRecipients, ImmutableSet<MailAddress> recipientWithError) {
            this.newRecipients = newRecipients;
            this.recipientWithError = recipientWithError;
        }

        public Set<MailAddress> getNewRecipients() {
            return this.newRecipients;
        }

        public Set<MailAddress> getRecipientWithError() {
            return this.recipientWithError;
        }
    }

    private static class Decision {
        private final MailAddress originalAddress;
        private final RrtExecutionResult executionResult;

        private Decision(MailAddress originalAddress, RrtExecutionResult executionResult) {
            this.originalAddress = originalAddress;
            this.executionResult = executionResult;
        }

        MailAddress originalAddress() {
            return this.originalAddress;
        }

        RrtExecutionResult executionResult() {
            return this.executionResult;
        }

        DsnParameters applyOnDsnParameters(DsnParameters dsnParameters) {
            ImmutableMap rcptParameters = dsnParameters.getRcptParameters();
            Optional<DsnParameters.RecipientDsnParameters> originalRcptParameter = Optional.ofNullable((DsnParameters.RecipientDsnParameters)rcptParameters.get((Object)this.originalAddress));
            return originalRcptParameter.map(parameters -> {
                Map newRcptParameters = (Map)this.executionResult.getNewRecipients().stream().map(newRcpt -> Pair.of((Object)newRcpt, (Object)parameters)).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
                Map rcptParametersWithoutOriginal = (Map)rcptParameters.entrySet().stream().filter(rcpt -> !((MailAddress)rcpt.getKey()).equals((Object)this.originalAddress)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
                return dsnParameters.withRcptParameters((Map)ImmutableMap.builder().putAll(rcptParametersWithoutOriginal).putAll(newRcptParameters).build());
            }).orElse(dsnParameters);
        }
    }
}

