/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import java.util.UUID;
import org.apache.james.events.Event;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.Group;
import org.apache.james.task.Task;
import org.apache.james.webadmin.service.EventDeadLettersRedeliverAllTask;
import org.apache.james.webadmin.service.EventDeadLettersRedeliverGroupTask;
import org.apache.james.webadmin.service.EventDeadLettersRedeliverOneTask;
import org.apache.james.webadmin.service.EventDeadLettersRedeliverService;
import reactor.core.publisher.Mono;

public class EventDeadLettersService {
    private final EventDeadLettersRedeliverService redeliverService;
    private final EventDeadLetters deadLetters;

    @Inject
    @VisibleForTesting
    public EventDeadLettersService(EventDeadLettersRedeliverService redeliverService, EventDeadLetters deadLetters) {
        this.redeliverService = redeliverService;
        this.deadLetters = deadLetters;
    }

    public List<String> listGroupsAsStrings() {
        return (List)this.deadLetters.groupsWithFailedEvents().map(Group::asString).collect(ImmutableList.toImmutableList()).block();
    }

    public List<String> listGroupsInsertionIdsAsStrings(Group group) {
        return (List)this.deadLetters.failedIds(group).map(EventDeadLetters.InsertionId::getId).map(UUID::toString).collect(ImmutableList.toImmutableList()).block();
    }

    public Mono<Event> getEvent(Group group, EventDeadLetters.InsertionId insertionId) {
        return this.deadLetters.failedEvent(group, insertionId);
    }

    public void deleteEvent(Group group, EventDeadLetters.InsertionId insertionId) {
        this.deadLetters.remove(group, insertionId).block();
    }

    public void deleteEvents(Group group) {
        this.deadLetters.remove(group).block();
    }

    public Task redeliverAllEvents(EventDeadLettersRedeliverService.RunningOptions runningOptions) {
        return new EventDeadLettersRedeliverAllTask(this.redeliverService, runningOptions);
    }

    public Task redeliverGroupEvents(Group group, EventDeadLettersRedeliverService.RunningOptions runningOptions) {
        return new EventDeadLettersRedeliverGroupTask(this.redeliverService, group, runningOptions);
    }

    public Task redeliverSingleEvent(Group group, EventDeadLetters.InsertionId insertionId) {
        return new EventDeadLettersRedeliverOneTask(this.redeliverService, group, insertionId);
    }
}

